/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferedRandomAccessFile
extends RandomAccessFile {
    private static final Logger LOG = LoggerFactory.getLogger(BufferedRandomAccessFile.class);
    static final int DEFAULT_BUFFER_SIZE = 65536;
    static final int BUFFER_BOUNDARY_MASK = -65536;
    private int capacity;
    private ByteBuffer dataBuffer;
    private long startPosition = 0L;
    private long currentPosition = 0L;
    private long validLastPosition = 0L;
    private long diskPosition = 0L;
    private boolean isDirty = false;
    private boolean isClosed = false;
    private boolean isEOF = false;

    public BufferedRandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
        this.init(65536);
    }

    public BufferedRandomAccessFile(File file, String mode, int size) throws IOException {
        super(file, mode);
        this.init(size);
    }

    public BufferedRandomAccessFile(String name2, String mode) throws IOException {
        super(name2, mode);
        this.init(65536);
    }

    public BufferedRandomAccessFile(String name2, String mode, int size) throws FileNotFoundException {
        super(name2, mode);
        this.init(size);
    }

    private void init(int size) {
        this.capacity = Math.max(65536, size);
        this.dataBuffer = ByteBuffer.wrap(new byte[this.capacity]);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.flush();
            super.close();
            this.isClosed = true;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        if (this.isDirty) {
            this.alignDiskPositionToBufferStartIfNeeded();
            int len = (int)(this.currentPosition - this.startPosition);
            super.write(this.dataBuffer.array(), 0, len);
            this.diskPosition = this.currentPosition;
            this.isDirty = false;
        }
    }

    private int fillBuffer() throws IOException {
        int n;
        int cnt = 0;
        for (int bytesToRead = this.capacity; bytesToRead > 0 && (n = super.read(this.dataBuffer.array(), cnt, bytesToRead)) >= 0; bytesToRead -= n) {
            cnt += n;
        }
        this.isEOF = cnt < this.dataBuffer.array().length;
        this.diskPosition += (long)cnt;
        return cnt;
    }

    private void alignDiskPositionToBufferStartIfNeeded() throws IOException {
        if (this.diskPosition != this.startPosition) {
            super.seek(this.startPosition);
            this.diskPosition = this.startPosition;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos >= this.validLastPosition || pos < this.startPosition) {
            this.flushBuffer();
            this.startPosition = pos & 0xFFFFFFFFFFFF0000L;
            this.alignDiskPositionToBufferStartIfNeeded();
            int n = this.fillBuffer();
            this.validLastPosition = this.startPosition + (long)n;
        } else if (pos < this.currentPosition) {
            this.flushBuffer();
        }
        this.currentPosition = pos;
    }

    @Override
    public long getFilePointer() {
        return this.currentPosition;
    }

    @Override
    public long length() throws IOException {
        return Math.max(this.currentPosition, super.length());
    }

    private boolean endOfBufferReached() {
        return this.currentPosition >= this.validLastPosition;
    }

    private boolean loadNewBlockToBuffer() throws IOException {
        if (this.isEOF) {
            return false;
        }
        this.seek(this.currentPosition);
        return this.currentPosition != this.validLastPosition;
    }

    @Override
    public int read() throws IOException {
        if (this.endOfBufferReached() && !this.loadNewBlockToBuffer()) {
            return -1;
        }
        byte res = this.dataBuffer.array()[(int)(this.currentPosition - this.startPosition)];
        ++this.currentPosition;
        return res & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.endOfBufferReached() && !this.loadNewBlockToBuffer()) {
            return -1;
        }
        len = Math.min(len, (int)(this.validLastPosition - this.currentPosition));
        int buffOff = (int)(this.currentPosition - this.startPosition);
        System.arraycopy(this.dataBuffer.array(), buffOff, b, off, len);
        this.currentPosition += (long)len;
        return len;
    }

    private long endPosition() {
        return this.startPosition + (long)this.capacity;
    }

    private boolean spaceAvailableInBuffer() {
        return this.isEOF && this.validLastPosition < this.endPosition();
    }

    @Override
    public void write(int v) throws IOException {
        byte[] b = new byte[]{(byte)v};
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int n = this.writeAtMost(b, off, len);
            off += n;
            len -= n;
            this.isDirty = true;
        }
    }

    private void expandBufferToCapacityIfNeeded() throws IOException {
        if (this.spaceAvailableInBuffer()) {
            this.validLastPosition = this.endPosition();
        } else {
            this.loadNewBlockToBuffer();
            if (this.currentPosition == this.validLastPosition) {
                this.validLastPosition = this.endPosition();
            }
        }
    }

    private int writeAtMost(byte[] b, int off, int len) throws IOException {
        if (this.endOfBufferReached()) {
            this.expandBufferToCapacityIfNeeded();
        }
        len = Math.min(len, (int)(this.validLastPosition - this.currentPosition));
        int buffOff = (int)(this.currentPosition - this.startPosition);
        System.arraycopy(b, off, this.dataBuffer.array(), buffOff, len);
        this.currentPosition += (long)len;
        return len;
    }
}

