/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.model.CleanFileInfo;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanMetadataMigrator;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanMetadataV1MigrationHandler;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanMetadataV2MigrationHandler;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanMigrator;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CleanerUtils.class);
    public static final String SAVEPOINTED_TIMESTAMPS = "savepointed_timestamps";
    public static final Integer CLEAN_METADATA_VERSION_1 = CleanMetadataV1MigrationHandler.VERSION;
    public static final Integer CLEAN_METADATA_VERSION_2;
    public static final Integer LATEST_CLEAN_METADATA_VERSION;

    public static HoodieCleanMetadata convertCleanMetadata(String startCleanTime, Option<Long> durationInMs, List<HoodieCleanStat> cleanStats, Map<String, String> extraMetadatafromCleanPlan) {
        HashMap<String, HoodieCleanPartitionMetadata> partitionMetadataMap = new HashMap<String, HoodieCleanPartitionMetadata>();
        HashMap<String, HoodieCleanPartitionMetadata> partitionBootstrapMetadataMap = new HashMap<String, HoodieCleanPartitionMetadata>();
        int totalDeleted = 0;
        String earliestCommitToRetain = null;
        String lastCompletedCommitTimestamp = "";
        for (HoodieCleanStat stat : cleanStats) {
            HoodieCleanPartitionMetadata metadata2 = new HoodieCleanPartitionMetadata(stat.getPartitionPath(), stat.getPolicy().name(), stat.getDeletePathPatterns(), stat.getSuccessDeleteFiles(), stat.getFailedDeleteFiles(), stat.isPartitionDeleted());
            partitionMetadataMap.put(stat.getPartitionPath(), metadata2);
            if (null != stat.getDeleteBootstrapBasePathPatterns() && !stat.getDeleteBootstrapBasePathPatterns().isEmpty()) {
                HoodieCleanPartitionMetadata bootstrapMetadata = new HoodieCleanPartitionMetadata(stat.getPartitionPath(), stat.getPolicy().name(), stat.getDeleteBootstrapBasePathPatterns(), stat.getSuccessDeleteBootstrapBaseFiles(), stat.getFailedDeleteBootstrapBaseFiles(), stat.isPartitionDeleted());
                partitionBootstrapMetadataMap.put(stat.getPartitionPath(), bootstrapMetadata);
            }
            totalDeleted += stat.getSuccessDeleteFiles().size();
            if (earliestCommitToRetain != null) continue;
            earliestCommitToRetain = stat.getEarliestCommitToRetain();
            lastCompletedCommitTimestamp = stat.getLastCompletedCommitTimestamp();
        }
        return new HoodieCleanMetadata(startCleanTime, durationInMs.orElseGet(() -> -1L), totalDeleted, earliestCommitToRetain, lastCompletedCommitTimestamp, partitionMetadataMap, CLEAN_METADATA_VERSION_2, partitionBootstrapMetadataMap, extraMetadatafromCleanPlan);
    }

    public static HoodieCleanMetadata getCleanerMetadata(HoodieTableMetaClient metaClient, HoodieInstant cleanInstant) throws IOException {
        CleanMetadataMigrator metadataMigrator = new CleanMetadataMigrator(metaClient);
        HoodieCleanMetadata cleanMetadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata(metaClient.getActiveTimeline().readCleanerInfoAsBytes(cleanInstant).get());
        return metadataMigrator.upgradeToLatest(cleanMetadata, cleanMetadata.getVersion());
    }

    public static HoodieCleanMetadata getCleanerMetadata(HoodieTableMetaClient metaClient, byte[] details) throws IOException {
        CleanMetadataMigrator metadataMigrator = new CleanMetadataMigrator(metaClient);
        HoodieCleanMetadata cleanMetadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata(details);
        return metadataMigrator.upgradeToLatest(cleanMetadata, cleanMetadata.getVersion());
    }

    public static Option<HoodieInstant> getEarliestCommitToRetain(HoodieTimeline commitsTimeline, HoodieCleaningPolicy cleaningPolicy, int commitsRetained, Instant latestInstant, int hoursRetained, HoodieTimelineTimeZone timeZone) {
        HoodieTimeline completedCommitsTimeline = commitsTimeline.filterCompletedInstants();
        Option<HoodieInstant> earliestCommitToRetain = Option.empty();
        if (cleaningPolicy == HoodieCleaningPolicy.KEEP_LATEST_COMMITS && completedCommitsTimeline.countInstants() > commitsRetained) {
            Option<HoodieInstant> earliestPendingCommits = commitsTimeline.filter(s -> !s.isCompleted()).firstInstant();
            earliestCommitToRetain = earliestPendingCommits.isPresent() ? completedCommitsTimeline.nthInstant(completedCommitsTimeline.countInstants() - commitsRetained).map(nthInstant -> {
                if (nthInstant.compareTo((HoodieInstant)earliestPendingCommits.get()) <= 0) {
                    return Option.of(nthInstant);
                }
                return completedCommitsTimeline.findInstantsBefore(((HoodieInstant)earliestPendingCommits.get()).requestedTime()).lastInstant();
            }).orElse(Option.empty()) : completedCommitsTimeline.nthInstant(completedCommitsTimeline.countInstants() - commitsRetained);
        } else if (cleaningPolicy == HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS) {
            ZonedDateTime latestDateTime = ZonedDateTime.ofInstant(latestInstant, timeZone.getZoneId());
            String earliestTimeToRetain = TimelineUtils.formatDate(Date.from(latestDateTime.minusHours(hoursRetained).toInstant()));
            earliestCommitToRetain = Option.fromJavaOptional(completedCommitsTimeline.getInstantsAsStream().filter(i -> InstantComparison.compareTimestamps(i.requestedTime(), InstantComparison.GREATER_THAN_OR_EQUALS, earliestTimeToRetain)).findFirst());
        }
        return earliestCommitToRetain;
    }

    public static HoodieCleanerPlan getCleanerPlan(HoodieTableMetaClient metaClient, HoodieInstant cleanInstant) throws IOException {
        CleanPlanMigrator cleanPlanMigrator = new CleanPlanMigrator(metaClient);
        HoodieCleanerPlan cleanerPlan = TimelineMetadataUtils.deserializeAvroMetadata(metaClient.getActiveTimeline().readCleanerInfoAsBytes(cleanInstant).get(), HoodieCleanerPlan.class);
        return cleanPlanMigrator.upgradeToLatest(cleanerPlan, cleanerPlan.getVersion());
    }

    public static HoodieCleanerPlan getCleanerPlan(HoodieTableMetaClient metaClient, byte[] details) throws IOException {
        CleanPlanMigrator cleanPlanMigrator = new CleanPlanMigrator(metaClient);
        HoodieCleanerPlan cleanerPlan = TimelineMetadataUtils.deserializeAvroMetadata(details, HoodieCleanerPlan.class);
        return cleanPlanMigrator.upgradeToLatest(cleanerPlan, cleanerPlan.getVersion());
    }

    public static List<HoodieCleanFileInfo> convertToHoodieCleanFileInfoList(List<CleanFileInfo> cleanFileInfoList) {
        return cleanFileInfoList.stream().map(CleanFileInfo::toHoodieFileCleanInfo).collect(Collectors.toList());
    }

    public static void rollbackFailedWrites(HoodieFailedWritesCleaningPolicy cleaningPolicy, String actionType, Functions.Function0<Boolean> rollbackFailedWritesFunc) {
        switch (actionType) {
            case "clean": {
                if (cleaningPolicy.isEager()) {
                    return;
                }
                if (!cleaningPolicy.isLazy()) break;
                LOG.info("Cleaned failed attempts if any");
                rollbackFailedWritesFunc.apply();
                return;
            }
            case "commit": {
                if (!cleaningPolicy.isEager()) break;
                LOG.info("Cleaned failed attempts if any");
                rollbackFailedWritesFunc.apply();
                return;
            }
            default: {
                throw new IllegalArgumentException("Unsupported action type " + actionType);
            }
        }
    }

    static {
        LATEST_CLEAN_METADATA_VERSION = CLEAN_METADATA_VERSION_2 = CleanMetadataV2MigrationHandler.VERSION;
    }
}

