/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.InstantFileNameParser;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalSchemaCache {
    private static final Logger LOG = LoggerFactory.getLogger(InternalSchemaCache.class);
    private static Object[] lockList = new Object[16];
    private static final Cache<String, TreeMap<Long, InternalSchema>> HISTORICAL_SCHEMA_CACHE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalSchema searchSchemaAndCache(long versionID, HoodieTableMetaClient metaClient) {
        Option<InternalSchema> candidateSchema = InternalSchemaCache.getSchemaByReadingCommitFile(versionID, metaClient);
        if (candidateSchema.isPresent()) {
            return candidateSchema.get();
        }
        String tablePath = metaClient.getBasePath().toString();
        Object object = lockList[tablePath.hashCode() & lockList.length - 1];
        synchronized (object) {
            TreeMap<Long, InternalSchema> historicalSchemas = (TreeMap<Long, InternalSchema>)HISTORICAL_SCHEMA_CACHE.getIfPresent((Object)tablePath);
            if (historicalSchemas == null || InternalSchemaUtils.searchSchema(versionID, historicalSchemas) == null) {
                historicalSchemas = InternalSchemaCache.getHistoricalSchemas(metaClient);
                HISTORICAL_SCHEMA_CACHE.put((Object)tablePath, historicalSchemas);
            } else {
                long maxVersionId = (Long)historicalSchemas.keySet().stream().max(Long::compareTo).get();
                if (versionID > maxVersionId) {
                    historicalSchemas = InternalSchemaCache.getHistoricalSchemas(metaClient);
                    HISTORICAL_SCHEMA_CACHE.put((Object)tablePath, historicalSchemas);
                }
            }
            return InternalSchemaUtils.searchSchema(versionID, historicalSchemas);
        }
    }

    private static TreeMap<Long, InternalSchema> getHistoricalSchemas(HoodieTableMetaClient metaClient) {
        TreeMap<Long, InternalSchema> result2 = new TreeMap<Long, InternalSchema>();
        FileBasedInternalSchemaStorageManager schemasManager = new FileBasedInternalSchemaStorageManager(metaClient);
        String historySchemaStr = schemasManager.getHistorySchemaStr();
        if (!StringUtils.isNullOrEmpty(historySchemaStr)) {
            result2 = SerDeHelper.parseSchemas(historySchemaStr);
        }
        return result2;
    }

    private static Option<InternalSchema> getSchemaByReadingCommitFile(long versionID, HoodieTableMetaClient metaClient) {
        try {
            HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
            List instants = timeline.getInstantsAsStream().filter(f -> f.requestedTime().equals(String.valueOf(versionID))).collect(Collectors.toList());
            if (instants.isEmpty()) {
                return Option.empty();
            }
            byte[] data2 = timeline.getInstantDetails((HoodieInstant)instants.get(0)).get();
            HoodieCommitMetadata metadata2 = metaClient.getCommitMetadataSerDe().deserialize((HoodieInstant)instants.get(0), data2, HoodieCommitMetadata.class);
            String latestInternalSchemaStr = metadata2.getMetadata("latest_schema");
            return SerDeHelper.fromJson(latestInternalSchemaStr);
        }
        catch (Exception e) {
            throw new HoodieException("Failed to read schema from commit metadata", e);
        }
    }

    public static Pair<Option<String>, Option<String>> getInternalSchemaAndAvroSchemaForClusteringAndCompaction(HoodieTableMetaClient metaClient, String compactionAndClusteringInstant) {
        HoodieTimeline timelineBeforeCurrentCompaction = metaClient.getCommitsAndCompactionTimeline().findInstantsBefore(compactionAndClusteringInstant).filterCompletedInstants();
        Option<HoodieInstant> lastInstantBeforeCurrentCompaction = timelineBeforeCurrentCompaction.lastInstant();
        if (lastInstantBeforeCurrentCompaction.isPresent()) {
            HoodieCommitMetadata metadata2;
            byte[] data2 = timelineBeforeCurrentCompaction.getInstantDetails(lastInstantBeforeCurrentCompaction.get()).get();
            try {
                metadata2 = metaClient.getCommitMetadataSerDe().deserialize(lastInstantBeforeCurrentCompaction.get(), data2, HoodieCommitMetadata.class);
            }
            catch (Exception e) {
                throw new HoodieException(String.format("cannot read metadata from commit: %s", lastInstantBeforeCurrentCompaction.get()), e);
            }
            String internalSchemaStr = metadata2.getMetadata("latest_schema");
            if (internalSchemaStr != null) {
                String existingSchemaStr = metadata2.getMetadata("schema");
                return Pair.of(Option.of(internalSchemaStr), Option.of(existingSchemaStr));
            }
        }
        return Pair.of(Option.empty(), Option.empty());
    }

    public static InternalSchema getInternalSchemaByVersionId(long versionId, String tablePath, HoodieStorage storage2, String validCommits, InstantFileNameParser fileNameParser, CommitMetadataSerDe commitMetadataSerDe, InstantGenerator instantGenerator) {
        FileBasedInternalSchemaStorageManager fileBasedInternalSchemaStorageManager;
        String latestHistorySchema;
        String avroSchema = "";
        Set commitSet = Arrays.stream(validCommits.split(",")).collect(Collectors.toSet());
        List<String> validateCommitList = commitSet.stream().map(fileNameParser::extractTimestamp).collect(Collectors.toList());
        StoragePath hoodieMetaPath = new StoragePath(tablePath, ".hoodie");
        StoragePath candidateCommitFile = commitSet.stream().filter(fileName -> fileNameParser.extractTimestamp((String)fileName).equals(versionId + "")).findFirst().map(f -> new StoragePath(hoodieMetaPath, (String)f)).orElse(null);
        if (candidateCommitFile != null) {
            try {
                byte[] data2;
                try (InputStream is = storage2.open(candidateCommitFile);){
                    data2 = FileIOUtils.readAsByteArray(is);
                }
                HoodieCommitMetadata metadata2 = commitMetadataSerDe.deserialize(instantGenerator.createNewInstant(new StoragePathInfo(candidateCommitFile, -1L, false, 0, 0L, 0L)), data2, HoodieCommitMetadata.class);
                String latestInternalSchemaStr = metadata2.getMetadata("latest_schema");
                avroSchema = metadata2.getMetadata("schema");
                if (latestInternalSchemaStr != null) {
                    return SerDeHelper.fromJson(latestInternalSchemaStr).orElse(null);
                }
            }
            catch (Exception e1) {
                LOG.warn("Cannot find internal schema from commit file {}. Falling back to parsing historical internal schema", (Object)candidateCommitFile);
            }
        }
        if ((latestHistorySchema = (fileBasedInternalSchemaStorageManager = new FileBasedInternalSchemaStorageManager(storage2, new StoragePath(tablePath))).getHistorySchemaStrByGivenValidCommits(validateCommitList)).isEmpty()) {
            return InternalSchema.getEmptyInternalSchema();
        }
        InternalSchema fileSchema = InternalSchemaUtils.searchSchema(versionId, SerDeHelper.parseSchemas(latestHistorySchema));
        return fileSchema.isEmptySchema() ? (StringUtils.isNullOrEmpty(avroSchema) ? InternalSchema.getEmptyInternalSchema() : AvroInternalSchemaConverter.convert(HoodieAvroUtils.addMetadataFields(new Schema.Parser().parse(avroSchema)))) : fileSchema;
    }

    public static InternalSchema getInternalSchemaByVersionId(long versionId, HoodieTableMetaClient metaClient) {
        InstantFileNameGenerator factory = metaClient.getInstantFileNameGenerator();
        String validCommitLists = metaClient.getCommitsAndCompactionTimeline().filterCompletedInstants().getInstantsAsStream().map(factory::getFileName).collect(Collectors.joining(","));
        return InternalSchemaCache.getInternalSchemaByVersionId(versionId, metaClient.getBasePath().toString(), metaClient.getStorage(), validCommitLists, metaClient.getInstantFileNameParser(), metaClient.getCommitMetadataSerDe(), metaClient.getInstantGenerator());
    }

    static {
        for (int i = 0; i < lockList.length; ++i) {
            InternalSchemaCache.lockList[i] = new Object();
        }
        HISTORICAL_SCHEMA_CACHE = Caffeine.newBuilder().maximumSize(1000L).weakValues().build();
    }
}

