/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.heartbeat.HoodieHeartbeatUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerUtils {
    public static final String MARKERS_FILENAME_PREFIX = "MARKERS";
    public static final String MARKER_TYPE_FILENAME = "MARKERS.type";
    private static final Logger LOG = LoggerFactory.getLogger(MarkerUtils.class);

    public static String stripMarkerFolderPrefix(String fullMarkerPath, String basePath, String instantTime) {
        ValidationUtils.checkArgument(fullMarkerPath.contains(".marker"), String.format("Using DIRECT markers but marker path does not contain extension: %s", ".marker"));
        String markerRootPath = new StoragePath(String.format("%s/%s/%s", basePath, ".hoodie/.temp", instantTime)).getPathWithoutSchemeAndAuthority().toString();
        return MarkerUtils.stripMarkerFolderPrefix(fullMarkerPath, markerRootPath);
    }

    public static String stripMarkerFolderPrefix(String fullMarkerPath, String markerDir) {
        int begin = fullMarkerPath.indexOf(markerDir);
        ValidationUtils.checkArgument(begin >= 0, "Not in marker dir. Marker Path=" + fullMarkerPath + ", Expected Marker Root=" + markerDir);
        return fullMarkerPath.substring(begin + markerDir.length() + 1);
    }

    public static boolean doesMarkerTypeFileExist(HoodieStorage storage2, String markerDir) throws IOException {
        return storage2.exists(new StoragePath(markerDir, MARKER_TYPE_FILENAME));
    }

    public static Option<MarkerType> readMarkerType(HoodieStorage storage2, String markerDir) {
        StoragePath markerTypeFilePath = new StoragePath(markerDir, MARKER_TYPE_FILENAME);
        InputStream inputStream = null;
        Option<MarkerType> content = Option.empty();
        try {
            if (!MarkerUtils.doesMarkerTypeFileExist(storage2, markerDir)) {
                Option<MarkerType> option = Option.empty();
                return option;
            }
            inputStream = storage2.open(markerTypeFilePath);
            String markerType = FileIOUtils.readAsUTFString(inputStream);
            if (StringUtils.isNullOrEmpty(markerType)) {
                Option<MarkerType> option = Option.empty();
                FileIOUtils.closeQuietly(inputStream);
                return option;
            }
            content = Option.of(MarkerType.valueOf(markerType));
            FileIOUtils.closeQuietly(inputStream);
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot read marker type file " + markerTypeFilePath + "; " + e.getMessage(), e);
        }
        finally {
            FileIOUtils.closeQuietly(inputStream);
        }
        return content;
    }

    public static void writeMarkerTypeToFile(MarkerType markerType, HoodieStorage storage2, String markerDir) {
        StoragePath markerTypeFilePath = new StoragePath(markerDir, MARKER_TYPE_FILENAME);
        OutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            outputStream = storage2.create(markerTypeFilePath, false);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            bufferedWriter.write(markerType.toString());
        }
        catch (IOException e) {
            try {
                throw new HoodieException("Failed to create marker type file " + markerTypeFilePath + "; " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                FileIOUtils.closeQuietly(bufferedWriter);
                FileIOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        FileIOUtils.closeQuietly(bufferedWriter);
        FileIOUtils.closeQuietly(outputStream);
    }

    public static void deleteMarkerTypeFile(HoodieStorage storage2, String markerDir) {
        StoragePath markerTypeFilePath = new StoragePath(markerDir, MARKER_TYPE_FILENAME);
        try {
            storage2.deleteFile(markerTypeFilePath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot delete marker type file " + markerTypeFilePath + "; " + e.getMessage(), e);
        }
    }

    public static Map<String, Set<String>> readTimelineServerBasedMarkersFromFileSystem(String markerDir, HoodieStorage storage2, HoodieEngineContext context, int parallelism) {
        StoragePath dirPath = new StoragePath(markerDir);
        try {
            if (storage2.exists(dirPath)) {
                Predicate<StoragePathInfo> prefixFilter = pathInfo -> pathInfo.getPath().getName().startsWith(MARKERS_FILENAME_PREFIX);
                Predicate<StoragePathInfo> markerTypeFilter = pathInfo -> !pathInfo.getPath().getName().equals(MARKER_TYPE_FILENAME);
                return FSUtils.parallelizeSubPathProcess(context, storage2, dirPath, parallelism, prefixFilter.and(markerTypeFilter), pairOfSubPathAndConf -> {
                    String markersFilePathStr = (String)pairOfSubPathAndConf.getKey();
                    StorageConfiguration conf = (StorageConfiguration)pairOfSubPathAndConf.getValue();
                    return MarkerUtils.readMarkersFromFile(new StoragePath(markersFilePathStr), conf);
                });
            }
            return new HashMap<String, Set<String>>();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    public static Set<String> readMarkersFromFile(StoragePath markersFilePath, StorageConfiguration<?> conf) {
        return MarkerUtils.readMarkersFromFile(markersFilePath, conf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readMarkersFromFile(StoragePath markersFilePath, StorageConfiguration<?> conf, boolean ignoreException) {
        InputStream inputStream = null;
        HashSet<String> markers = new HashSet();
        try {
            LOG.debug("Read marker file: " + markersFilePath);
            HoodieStorage storage2 = HoodieStorageUtils.getStorage(markersFilePath, conf);
            inputStream = storage2.open(markersFilePath);
            markers = new HashSet<String>(FileIOUtils.readAsUTFStringLines(inputStream));
        }
        catch (IOException e) {
            try {
                String errorMessage2 = "Failed to read MARKERS file " + markersFilePath;
                if (!ignoreException) {
                    throw new HoodieIOException(errorMessage2, e);
                }
                LOG.warn(errorMessage2 + ". Ignoring the exception and continue.", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileIOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            FileIOUtils.closeQuietly(inputStream);
        }
        FileIOUtils.closeQuietly(inputStream);
        return markers;
    }

    public static List<StoragePath> getAllMarkerDir(StoragePath tempPath, HoodieStorage storage2) throws IOException {
        return storage2.listDirectEntries(tempPath).stream().map(StoragePathInfo::getPath).collect(Collectors.toList());
    }

    public static boolean hasCommitConflict(HoodieActiveTimeline activeTimeline, Set<String> currentFileIDs, Set<HoodieInstant> completedCommitInstants) {
        HashSet<HoodieInstant> currentInstants = new HashSet<HoodieInstant>(activeTimeline.reload().getCommitsTimeline().filterCompletedInstants().getInstants());
        currentInstants.removeAll(completedCommitInstants);
        Set missingFileIDs = currentInstants.stream().flatMap(instant -> {
            try {
                TimelineLayout layout = TimelineLayout.fromVersion(activeTimeline.getTimelineLayoutVersion());
                return layout.getCommitMetadataSerDe().deserialize((HoodieInstant)instant, activeTimeline.getInstantDetails((HoodieInstant)instant).get(), HoodieCommitMetadata.class).getFileIdAndRelativePaths().keySet().stream();
            }
            catch (Exception e) {
                return Stream.empty();
            }
        }).collect(Collectors.toSet());
        currentFileIDs.retainAll(missingFileIDs);
        return !currentFileIDs.isEmpty();
    }

    public static List<String> getCandidateInstants(HoodieActiveTimeline activeTimeline, List<StoragePath> instants, String currentInstantTime, long maxAllowableHeartbeatIntervalInMs, HoodieStorage storage2, String basePath) {
        return instants.stream().map(StoragePath::toString).filter(instantPath -> {
            String instantTime = MarkerUtils.markerDirToInstantTime(instantPath);
            return instantTime.compareToIgnoreCase(currentInstantTime) < 0 && !activeTimeline.filterPendingCompactionTimeline().containsInstant(instantTime) && !activeTimeline.filterPendingReplaceOrClusteringTimeline().containsInstant(instantTime);
        }).filter(instantPath -> {
            try {
                return !HoodieHeartbeatUtils.isHeartbeatExpired(MarkerUtils.markerDirToInstantTime(instantPath), maxAllowableHeartbeatIntervalInMs, storage2, basePath);
            }
            catch (IOException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    public static String makerToPartitionAndFileID(String marker) {
        String[] ele = marker.split("_");
        return ele[0];
    }

    public static String markerDirToInstantTime(String marker) {
        String[] ele = marker.split("/");
        return ele[ele.length - 1];
    }
}

