/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.hash;

import java.io.Serializable;
import org.apache.hudi.exception.HoodieNotSupportedException;

public abstract class HoodieIndexID
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract String getName();

    public abstract int bits();

    public abstract byte[] asBytes();

    public abstract String toString();

    public String asBase64EncodedString() {
        throw new HoodieNotSupportedException("Unsupported hash for " + (Object)((Object)this.getType()));
    }

    protected abstract Type getType();

    public final boolean isColumnID() {
        return this.getType() == Type.COLUMN;
    }

    public final boolean isPartition() {
        return this.getType() == Type.PARTITION;
    }

    public final boolean isFileID() {
        return this.getType() == Type.FILE;
    }

    public static enum Type {
        COLUMN("HoodieColumnID"),
        PARTITION("HoodiePartitionID"),
        FILE("HoodieFileID");

        private final String name;

        private Type(String name2) {
            this.name = name2;
        }

        public String toString() {
            return "Type{name='" + this.name + "'}";
        }
    }
}

