/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.queue;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import org.apache.hudi.common.util.queue.DisruptorWaitStrategyType;
import org.apache.hudi.exception.HoodieException;

public class WaitStrategyFactory {
    public static final String DEFAULT_STRATEGY = DisruptorWaitStrategyType.BLOCKING_WAIT.name();

    public static WaitStrategy build(String name2) {
        DisruptorWaitStrategyType strategyType = DisruptorWaitStrategyType.valueOf(name2);
        switch (strategyType) {
            case BLOCKING_WAIT: {
                return new BlockingWaitStrategy();
            }
            case SLEEPING_WAIT: {
                return new SleepingWaitStrategy();
            }
            case YIELDING_WAIT: {
                return new YieldingWaitStrategy();
            }
            case BUSY_SPIN_WAIT: {
                return new BusySpinWaitStrategy();
            }
        }
        throw new HoodieException("Unsupported Executor Type " + name2);
    }
}

