/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieArrayWritableAvroUtils {
    private static final Cache<Pair<Schema, Schema>, int[]> PROJECTION_CACHE = Caffeine.newBuilder().maximumSize(1000L).build();

    public static int[] getProjection(Schema from, Schema to) {
        return (int[])PROJECTION_CACHE.get(Pair.of(from, to), schemas -> {
            List toFields = to.getFields();
            int[] newProjection = new int[toFields.size()];
            for (int i = 0; i < newProjection.length; ++i) {
                newProjection[i] = from.getField(((Schema.Field)toFields.get(i)).name()).pos();
            }
            return newProjection;
        });
    }

    public static UnaryOperator<ArrayWritable> projectRecord(Schema from, Schema to) {
        int[] projection = HoodieArrayWritableAvroUtils.getProjection(from, to);
        return arrayWritable -> {
            Writable[] values2 = new Writable[arrayWritable.get().length];
            for (int i = 0; i < projection.length; ++i) {
                values2[i] = arrayWritable.get()[projection[i]];
            }
            arrayWritable.set(values2);
            return arrayWritable;
        };
    }

    public static int[] getReverseProjection(Schema from, Schema to) {
        return (int[])PROJECTION_CACHE.get(Pair.of(from, to), schemas -> {
            List fromFields = from.getFields();
            int[] newProjection = new int[fromFields.size()];
            for (int i = 0; i < newProjection.length; ++i) {
                newProjection[i] = to.getField(((Schema.Field)fromFields.get(i)).name()).pos();
            }
            return newProjection;
        });
    }

    public static UnaryOperator<ArrayWritable> reverseProject(Schema from, Schema to) {
        int[] projection = HoodieArrayWritableAvroUtils.getReverseProjection(from, to);
        return arrayWritable -> {
            Writable[] values2 = new Writable[to.getFields().size()];
            for (int i = 0; i < projection.length; ++i) {
                values2[projection[i]] = arrayWritable.get()[i];
            }
            arrayWritable.set(values2);
            return arrayWritable;
        };
    }

    public static Object getWritableValue(ArrayWritable arrayWritable, ArrayWritableObjectInspector objectInspector, String name2) {
        return objectInspector.getStructFieldData((Object)arrayWritable, objectInspector.getStructFieldRef(name2));
    }
}

