/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class KeyRangeNode
implements Comparable<KeyRangeNode>,
Serializable {
    private final List<String> fileNameList = new ArrayList<String>();
    private final String minRecordKey;
    private final String maxRecordKey;
    private String rightSubTreeMax = null;
    private String leftSubTreeMax = null;
    private String rightSubTreeMin = null;
    private String leftSubTreeMin = null;
    private KeyRangeNode left = null;
    private KeyRangeNode right = null;

    KeyRangeNode(String minRecordKey, String maxRecordKey, String fileName) {
        this.fileNameList.add(fileName);
        this.minRecordKey = minRecordKey;
        this.maxRecordKey = maxRecordKey;
    }

    void addFiles(List<String> newFiles) {
        this.fileNameList.addAll(newFiles);
    }

    public String toString() {
        return "KeyRangeNode{minRecordKey='" + this.minRecordKey + '\'' + ", maxRecordKey='" + this.maxRecordKey + '\'' + ", fileNameList=" + this.fileNameList + ", rightSubTreeMax='" + this.rightSubTreeMax + '\'' + ", leftSubTreeMax='" + this.leftSubTreeMax + '\'' + ", rightSubTreeMin='" + this.rightSubTreeMin + '\'' + ", leftSubTreeMin='" + this.leftSubTreeMin + '\'' + '}';
    }

    @Override
    public int compareTo(KeyRangeNode that) {
        int compareValue = this.minRecordKey.compareTo(that.minRecordKey);
        if (compareValue == 0) {
            return this.maxRecordKey.compareTo(that.maxRecordKey);
        }
        return compareValue;
    }

    public List<String> getFileNameList() {
        return this.fileNameList;
    }

    public String getMinRecordKey() {
        return this.minRecordKey;
    }

    public String getMaxRecordKey() {
        return this.maxRecordKey;
    }

    public String getRightSubTreeMin() {
        return this.rightSubTreeMin;
    }

    public void setRightSubTreeMin(String rightSubTreeMin) {
        this.rightSubTreeMin = rightSubTreeMin;
    }

    public String getLeftSubTreeMin() {
        return this.leftSubTreeMin;
    }

    public void setLeftSubTreeMin(String leftSubTreeMin) {
        this.leftSubTreeMin = leftSubTreeMin;
    }

    public String getRightSubTreeMax() {
        return this.rightSubTreeMax;
    }

    public void setRightSubTreeMax(String rightSubTreeMax) {
        this.rightSubTreeMax = rightSubTreeMax;
    }

    public String getLeftSubTreeMax() {
        return this.leftSubTreeMax;
    }

    public void setLeftSubTreeMax(String leftSubTreeMax) {
        this.leftSubTreeMax = leftSubTreeMax;
    }

    public KeyRangeNode getLeft() {
        return this.left;
    }

    public void setLeft(KeyRangeNode left) {
        this.left = left;
    }

    public KeyRangeNode getRight() {
        return this.right;
    }

    public void setRight(KeyRangeNode right) {
        this.right = right;
    }
}

