/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.visitor.InternalSchemaVisitor;
import org.apache.hudi.internal.schema.visitor.NameToIDVisitor;
import org.apache.hudi.internal.schema.visitor.NameToPositionVisitor;

public class InternalSchemaBuilder
implements Serializable {
    private static final InternalSchemaBuilder INSTANCE = new InternalSchemaBuilder();

    public static InternalSchemaBuilder getBuilder() {
        return INSTANCE;
    }

    private InternalSchemaBuilder() {
    }

    public Map<Integer, String> buildIdToName(Type type2) {
        HashMap<Integer, String> result2 = new HashMap<Integer, String>();
        this.buildNameToId(type2).forEach((k, v) -> result2.put((Integer)v, (String)k));
        return result2;
    }

    public Map<String, Integer> buildNameToId(Type type2) {
        return this.visit(type2, new NameToIDVisitor());
    }

    Map<String, Integer> buildNameToPosition(Type type2) {
        return this.visit(type2, new NameToPositionVisitor());
    }

    public <T> T visit(InternalSchema schema, InternalSchemaVisitor<T> visitor2) {
        return visitor2.schema(schema, this.visit(schema.getRecord(), visitor2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T visit(Type type2, InternalSchemaVisitor<T> visitor2) {
        switch (type2.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type2;
                ArrayList<T> results = new ArrayList<T>();
                for (Types.Field f : record.fields()) {
                    T result2;
                    visitor2.beforeField(f);
                    try {
                        result2 = this.visit(f.type(), visitor2);
                    }
                    finally {
                        visitor2.afterField(f);
                    }
                    results.add(visitor2.field(f, result2));
                }
                return visitor2.record(record, results);
            }
            case ARRAY: {
                T elementResult;
                Types.ArrayType array = (Types.ArrayType)type2;
                Types.Field elementField = array.field(array.elementId());
                visitor2.beforeArrayElement(elementField);
                try {
                    elementResult = this.visit(elementField.type(), visitor2);
                }
                finally {
                    visitor2.afterArrayElement(elementField);
                }
                return visitor2.array(array, elementResult);
            }
            case MAP: {
                T valueResult;
                T keyResult;
                Types.MapType map2 = (Types.MapType)type2;
                Types.Field keyField = map2.field(map2.keyId());
                visitor2.beforeMapKey(keyField);
                try {
                    keyResult = this.visit(map2.keyType(), visitor2);
                }
                finally {
                    visitor2.afterMapKey(keyField);
                }
                Types.Field valueField = map2.field(map2.valueId());
                visitor2.beforeMapValue(valueField);
                try {
                    valueResult = this.visit(map2.valueType(), visitor2);
                }
                finally {
                    visitor2.afterMapValue(valueField);
                }
                return visitor2.map(map2, keyResult, valueResult);
            }
        }
        return visitor2.primitive((Type.PrimitiveType)type2);
    }

    public Map<Integer, Types.Field> buildIdToField(Type type2) {
        HashMap<Integer, Types.Field> idToField = new HashMap<Integer, Types.Field>();
        this.visitIdToField(type2, idToField);
        return idToField;
    }

    private void visitIdToField(Type type2, Map<Integer, Types.Field> index) {
        switch (type2.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type2;
                for (Types.Field field : record.fields()) {
                    this.visitIdToField(field.type(), index);
                    index.put(field.fieldId(), field);
                }
                return;
            }
            case ARRAY: {
                Types.ArrayType array = (Types.ArrayType)type2;
                this.visitIdToField(array.elementType(), index);
                for (Types.Field field : array.fields()) {
                    index.put(field.fieldId(), field);
                }
                return;
            }
            case MAP: {
                Types.MapType map2 = (Types.MapType)type2;
                this.visitIdToField(map2.keyType(), index);
                this.visitIdToField(map2.valueType(), index);
                for (Types.Field field : map2.fields()) {
                    index.put(field.fieldId(), field);
                }
                return;
            }
        }
    }

    public Map<Integer, Integer> index2Parents(Types.RecordType record) {
        HashMap<Integer, Integer> result2 = new HashMap<Integer, Integer>();
        LinkedList<Integer> parentIds = new LinkedList<Integer>();
        this.index2Parents(record, parentIds, result2);
        return result2;
    }

    private void index2Parents(Type type2, Deque<Integer> pids, Map<Integer, Integer> id2p) {
        switch (type2.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type2;
                for (Types.Field f : record.fields()) {
                    pids.push(f.fieldId());
                    this.index2Parents(f.type(), pids, id2p);
                    pids.pop();
                }
                for (Types.Field f : record.fields()) {
                    if (pids.isEmpty()) continue;
                    Integer pid = pids.peek();
                    id2p.put(f.fieldId(), pid);
                }
                return;
            }
            case ARRAY: {
                Types.ArrayType array = (Types.ArrayType)type2;
                Types.Field elementField = array.field(array.elementId());
                pids.push(elementField.fieldId());
                this.index2Parents(elementField.type(), pids, id2p);
                pids.pop();
                id2p.put(array.elementId(), pids.peek());
                return;
            }
            case MAP: {
                Types.MapType map2 = (Types.MapType)type2;
                Types.Field keyField = map2.field(map2.keyId());
                Types.Field valueField = map2.field(map2.valueId());
                pids.push(map2.keyId());
                this.index2Parents(keyField.type(), pids, id2p);
                pids.pop();
                pids.push(map2.valueId());
                this.index2Parents(valueField.type(), pids, id2p);
                pids.pop();
                id2p.put(map2.keyId(), pids.peek());
                id2p.put(map2.valueId(), pids.peek());
                return;
            }
        }
    }

    public Type refreshNewId(Type type2, AtomicInteger nextId) {
        switch (type2.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type2;
                List<Types.Field> oldFields = record.fields();
                int currentId = nextId.get();
                nextId.set(currentId + record.fields().size());
                ArrayList<Types.Field> internalFields = new ArrayList<Types.Field>();
                for (int i = 0; i < oldFields.size(); ++i) {
                    Types.Field oldField = oldFields.get(i);
                    Type fieldType = this.refreshNewId(oldField.type(), nextId);
                    internalFields.add(Types.Field.get(currentId++, oldField.isOptional(), oldField.name(), fieldType, oldField.doc()));
                }
                return Types.RecordType.get(internalFields);
            }
            case ARRAY: {
                Types.ArrayType array = (Types.ArrayType)type2;
                int elementId = nextId.get();
                nextId.set(elementId + 1);
                Type elementType = this.refreshNewId(array.elementType(), nextId);
                return Types.ArrayType.get(elementId, array.isElementOptional(), elementType);
            }
            case MAP: {
                Types.MapType map2 = (Types.MapType)type2;
                int keyId = nextId.get();
                int valueId = keyId + 1;
                nextId.set(keyId + 2);
                Type keyType = this.refreshNewId(map2.keyType(), nextId);
                Type valueType = this.refreshNewId(map2.valueType(), nextId);
                return Types.MapType.get(keyId, valueId, keyType, valueType, map2.isValueOptional());
            }
        }
        return type2;
    }
}

