/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.constant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hudi.common.config.EnumDescription;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.table.HoodieTableConfig;

@EnumDescription(value="Key generator type, indicating the key generator class to use, that implements `org.apache.hudi.keygen.KeyGenerator`.")
public enum KeyGeneratorType {
    SIMPLE("org.apache.hudi.keygen.SimpleKeyGenerator"),
    SIMPLE_AVRO("org.apache.hudi.keygen.SimpleAvroKeyGenerator"),
    COMPLEX("org.apache.hudi.keygen.ComplexKeyGenerator"),
    COMPLEX_AVRO("org.apache.hudi.keygen.ComplexAvroKeyGenerator"),
    TIMESTAMP("org.apache.hudi.keygen.TimestampBasedKeyGenerator"),
    TIMESTAMP_AVRO("org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator"),
    CUSTOM("org.apache.hudi.keygen.CustomKeyGenerator"),
    CUSTOM_AVRO("org.apache.hudi.keygen.CustomAvroKeyGenerator"),
    NON_PARTITION("org.apache.hudi.keygen.NonpartitionedKeyGenerator"),
    NON_PARTITION_AVRO("org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator"),
    GLOBAL_DELETE("org.apache.hudi.keygen.GlobalDeleteKeyGenerator"),
    GLOBAL_DELETE_AVRO("org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator"),
    AUTO_RECORD("org.apache.hudi.keygen.AutoRecordGenWrapperKeyGenerator"),
    AUTO_RECORD_AVRO("org.apache.hudi.keygen.AutoRecordGenWrapperAvroKeyGenerator"),
    HOODIE_TABLE_METADATA("org.apache.hudi.metadata.HoodieTableMetadataKeyGenerator"),
    SPARK_SQL("org.apache.spark.sql.hudi.command.SqlKeyGenerator"),
    SPARK_SQL_UUID("org.apache.spark.sql.hudi.command.UuidKeyGenerator"),
    SPARK_SQL_MERGE_INTO("org.apache.spark.sql.hudi.command.MergeIntoKeyGenerator"),
    STREAMER_TEST("org.apache.hudi.utilities.deltastreamer.TestHoodieDeltaStreamer$TestGenerator");

    private final String className;

    private KeyGeneratorType(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public static KeyGeneratorType fromClassName(String className) {
        for (KeyGeneratorType type2 : KeyGeneratorType.values()) {
            if (!type2.getClassName().equals(className)) continue;
            return type2;
        }
        throw new IllegalArgumentException("No KeyGeneratorType found for class name: " + className);
    }

    public static List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>(KeyGeneratorType.values().length);
        Arrays.stream(KeyGeneratorType.values()).forEach(x -> names.add(x.name()));
        return names;
    }

    @Nullable
    public static String getKeyGeneratorClassName(HoodieConfig config) {
        if (config.contains(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME)) {
            return config.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME);
        }
        if (config.contains(HoodieTableConfig.KEY_GENERATOR_TYPE)) {
            return KeyGeneratorType.valueOf(config.getString(HoodieTableConfig.KEY_GENERATOR_TYPE)).getClassName();
        }
        return null;
    }

    @Nullable
    public static String getKeyGeneratorClassName(Map<String, String> config) {
        if (config.containsKey(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            return config.get(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key());
        }
        if (config.containsKey(HoodieTableConfig.KEY_GENERATOR_TYPE.key())) {
            return KeyGeneratorType.valueOf(config.get(HoodieTableConfig.KEY_GENERATOR_TYPE.key())).getClassName();
        }
        return null;
    }
}

