/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.optimize;

import java.math.BigInteger;
import org.davidmoten.hilbert.HilbertCurve;

public class HilbertCurveUtils {
    public static byte[] indexBytes(HilbertCurve hilbertCurve, long[] points, int paddingNum) {
        BigInteger index = hilbertCurve.index(points);
        return HilbertCurveUtils.paddingToNByte(index.toByteArray(), paddingNum);
    }

    public static byte[] paddingToNByte(byte[] a, int paddingNum) {
        if (a.length == paddingNum) {
            return a;
        }
        if (a.length > paddingNum) {
            byte[] result2 = new byte[paddingNum];
            System.arraycopy(a, 0, result2, 0, paddingNum);
            return result2;
        }
        int paddingSize = paddingNum - a.length;
        byte[] result3 = new byte[paddingNum];
        for (int i = 0; i < paddingSize; ++i) {
            result3[i] = 0;
        }
        System.arraycopy(a, 0, result3, paddingSize, a.length);
        return result3;
    }
}

