/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.iterators.UnmodifiableIterator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompoundConfiguration
extends Configuration {
    private Configuration mutableConf = null;
    private final List<ImmutableConfigMap> configs = new ArrayList<ImmutableConfigMap>();

    void freezeMutableConf() {
        if (this.mutableConf == null) {
            return;
        }
        this.configs.add(0, new ImmutableConfWrapper(this.mutableConf));
        this.mutableConf = null;
    }

    public CompoundConfiguration add(Configuration conf) {
        this.freezeMutableConf();
        if (conf instanceof CompoundConfiguration) {
            this.configs.addAll(0, ((CompoundConfiguration)conf).configs);
            return this;
        }
        this.configs.add(0, new ImmutableConfWrapper(conf));
        return this;
    }

    public CompoundConfiguration addBytesMap(final Map<Bytes, Bytes> map2) {
        this.freezeMutableConf();
        this.configs.add(0, new ImmutableConfigMap(){
            private final Map<Bytes, Bytes> m;
            {
                this.m = map2;
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                HashMap<String, String> ret = new HashMap<String, String>();
                for (Map.Entry entry : map2.entrySet()) {
                    String key = Bytes.toString(((Bytes)entry.getKey()).get());
                    String val = entry.getValue() == null ? null : Bytes.toString(((Bytes)entry.getValue()).get());
                    ret.put(key, val);
                }
                return ret.entrySet().iterator();
            }

            @Override
            public String get(String key) {
                Bytes ibw = new Bytes(Bytes.toBytes(key));
                if (!this.m.containsKey(ibw)) {
                    return null;
                }
                Bytes value = this.m.get(ibw);
                if (value == null || value.get() == null) {
                    return null;
                }
                return Bytes.toString(value.get());
            }

            @Override
            public String getRaw(String key) {
                return this.get(key);
            }

            @Override
            public Class<?> getClassByName(String name2) throws ClassNotFoundException {
                return null;
            }

            @Override
            public int size() {
                return this.m.size();
            }

            public String toString() {
                return this.m.toString();
            }
        });
        return this;
    }

    public CompoundConfiguration addStringMap(final Map<String, String> map2) {
        this.freezeMutableConf();
        this.configs.add(0, new ImmutableConfigMap(){
            private final Map<String, String> m;
            {
                this.m = map2;
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return map2.entrySet().iterator();
            }

            @Override
            public String get(String key) {
                return this.m.get(key);
            }

            @Override
            public String getRaw(String key) {
                return this.get(key);
            }

            @Override
            public Class<?> getClassByName(String name2) throws ClassNotFoundException {
                return null;
            }

            @Override
            public int size() {
                return this.m.size();
            }

            public String toString() {
                return this.m.toString();
            }
        });
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompoundConfiguration: " + this.configs.size() + " configs");
        for (ImmutableConfigMap m : this.configs) {
            sb.append(m);
        }
        return sb.toString();
    }

    public String get(String key) {
        String value;
        if (this.mutableConf != null && (value = this.mutableConf.get(key)) != null) {
            return value;
        }
        for (ImmutableConfigMap m : this.configs) {
            String value2 = m.get(key);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public String getRaw(String key) {
        String value;
        if (this.mutableConf != null && (value = this.mutableConf.getRaw(key)) != null) {
            return value;
        }
        for (ImmutableConfigMap m : this.configs) {
            String value2 = m.getRaw(key);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public Class<?> getClassByName(String name2) throws ClassNotFoundException {
        Class value;
        if (this.mutableConf != null && (value = this.mutableConf.getClassByName(name2)) != null) {
            return value;
        }
        for (ImmutableConfigMap m : this.configs) {
            Class<?> value2 = m.getClassByName(name2);
            if (value2 == null) continue;
            return value2;
        }
        throw new ClassNotFoundException();
    }

    public int size() {
        int ret = 0;
        if (this.mutableConf != null) {
            ret += this.mutableConf.size();
        }
        for (ImmutableConfigMap m : this.configs) {
            ret += m.size();
        }
        return ret;
    }

    public String get(String name2, String defaultValue) {
        String ret = this.get(name2);
        return ret == null ? defaultValue : ret;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap ret = new HashMap();
        if (!this.configs.isEmpty()) {
            for (int i = this.configs.size() - 1; i >= 0; --i) {
                ImmutableConfigMap map2 = this.configs.get(i);
                for (Map.Entry entry : map2) {
                    ret.put(entry.getKey(), entry.getValue());
                }
            }
        }
        if (this.mutableConf != null) {
            for (Map.Entry entry : this.mutableConf) {
                ret.put(entry.getKey(), entry.getValue());
            }
        }
        return UnmodifiableIterator.unmodifiableIterator(ret.entrySet().iterator());
    }

    public void set(String name2, String value) {
        if (this.mutableConf == null) {
            this.mutableConf = new Configuration(false);
        }
        this.mutableConf.set(name2, value);
    }

    public void clear() {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void writeXml(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    static class ImmutableConfWrapper
    implements ImmutableConfigMap {
        private final Configuration c;

        ImmutableConfWrapper(Configuration conf) {
            this.c = conf;
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return this.c.iterator();
        }

        @Override
        public String get(String key) {
            return this.c.get(key);
        }

        @Override
        public String getRaw(String key) {
            return this.c.getRaw(key);
        }

        @Override
        public Class<?> getClassByName(String name2) throws ClassNotFoundException {
            return this.c.getClassByName(name2);
        }

        @Override
        public int size() {
            return this.c.size();
        }

        public String toString() {
            return this.c.toString();
        }
    }

    private static interface ImmutableConfigMap
    extends Iterable<Map.Entry<String, String>> {
        public String get(String var1);

        public String getRaw(String var1);

        public Class<?> getClassByName(String var1) throws ClassNotFoundException;

        public int size();
    }
}

