/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.client.Durability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class Append
extends Mutation {
    private static final Logger LOG = LoggerFactory.getLogger(Append.class);
    private static final long HEAP_OVERHEAD = ClassSize.REFERENCE + ClassSize.TIMERANGE;
    private TimeRange tr = TimeRange.allTime();

    public Append setTimeRange(long minStamp, long maxStamp) {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    @Override
    protected long extraHeapSize() {
        return HEAP_OVERHEAD;
    }

    @Override
    public Append setReturnResults(boolean returnResults) {
        super.setReturnResults(returnResults);
        return this;
    }

    @Override
    public boolean isReturnResults() {
        return super.isReturnResults();
    }

    public Append(byte[] row) {
        this(row, 0, row.length);
    }

    public Append(Append appendToCopy) {
        super(appendToCopy);
        this.tr = appendToCopy.getTimeRange();
    }

    public Append(byte[] rowArray, int rowOffset, int rowLength) {
        Append.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy(rowArray, rowOffset, rowLength);
    }

    public Append(byte[] row, long ts, NavigableMap<byte[], List<Cell>> familyMap) {
        super(row, ts, familyMap);
    }

    @Deprecated
    public Append add(byte[] family, byte[] qualifier, byte[] value) {
        return this.addColumn(family, qualifier, value);
    }

    public Append addColumn(byte[] family, byte[] qualifier, byte[] value) {
        KeyValue kv = new KeyValue(this.row, family, qualifier, this.ts, KeyValue.Type.Put, value);
        return this.add(kv);
    }

    @Override
    public Append add(Cell cell) {
        try {
            super.add(cell);
        }
        catch (IOException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        return this;
    }

    @Override
    public Append setTimestamp(long timestamp) {
        super.setTimestamp(timestamp);
        return this;
    }

    @Override
    public Append setAttribute(String name2, byte[] value) {
        return (Append)super.setAttribute(name2, value);
    }

    @Override
    public Append setId(String id) {
        return (Append)super.setId(id);
    }

    @Override
    public Append setDurability(Durability d) {
        return (Append)super.setDurability(d);
    }

    @Override
    @Deprecated
    public Append setFamilyCellMap(NavigableMap<byte[], List<Cell>> map2) {
        return (Append)super.setFamilyCellMap(map2);
    }

    @Override
    public Append setClusterIds(List<UUID> clusterIds) {
        return (Append)super.setClusterIds(clusterIds);
    }

    @Override
    public Append setCellVisibility(CellVisibility expression) {
        return (Append)super.setCellVisibility(expression);
    }

    @Override
    public Append setACL(String user, Permission perms) {
        return (Append)super.setACL(user, perms);
    }

    @Override
    public Append setACL(Map<String, Permission> perms) {
        return (Append)super.setACL(perms);
    }

    @Override
    public Append setPriority(int priority) {
        return (Append)super.setPriority(priority);
    }

    @Override
    public Append setTTL(long ttl) {
        return (Append)super.setTTL(ttl);
    }
}

