/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncRpcRetryingCaller;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncSingleRequestRpcRetryingCaller<T>
extends AsyncRpcRetryingCaller<T> {
    private final TableName tableName;
    private final byte[] row;
    private final int replicaId;
    private final RegionLocateType locateType;
    private final Callable<T> callable;

    public AsyncSingleRequestRpcRetryingCaller(Timer retryTimer, AsyncConnectionImpl conn, TableName tableName, byte[] row, int replicaId, RegionLocateType locateType, Callable<T> callable, int priority, long pauseNs, long pauseForCQTBENs, int maxAttempts, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        super(retryTimer, conn, priority, pauseNs, pauseForCQTBENs, maxAttempts, operationTimeoutNs, rpcTimeoutNs, startLogErrorsCnt);
        this.tableName = tableName;
        this.row = row;
        this.replicaId = replicaId;
        this.locateType = locateType;
        this.callable = callable;
    }

    private void call(HRegionLocation loc) {
        ClientProtos.ClientService.Interface stub;
        try {
            stub = this.conn.getRegionServerStub(loc.getServerName());
        }
        catch (IOException e) {
            this.onError(e, () -> "Get async stub to " + loc.getServerName() + " for '" + Bytes.toStringBinary(this.row) + "' in " + loc.getRegion().getEncodedName() + " of " + this.tableName + " failed", err -> this.conn.getLocator().updateCachedLocationOnError(loc, (Throwable)err));
            return;
        }
        this.resetCallTimeout();
        FutureUtils.addListener(this.callable.call(this.controller, loc, stub), (result2, error) -> {
            if (error != null) {
                this.onError((Throwable)error, () -> "Call to " + loc.getServerName() + " for '" + Bytes.toStringBinary(this.row) + "' in " + loc.getRegion().getEncodedName() + " of " + this.tableName + " failed", err -> this.conn.getLocator().updateCachedLocationOnError(loc, (Throwable)err));
                return;
            }
            this.future.complete(result2);
        });
    }

    @Override
    protected void doCall() {
        long locateTimeoutNs;
        if (this.operationTimeoutNs > 0L) {
            locateTimeoutNs = this.remainingTimeNs();
            if (locateTimeoutNs <= 0L) {
                this.completeExceptionally();
                return;
            }
        } else {
            locateTimeoutNs = -1L;
        }
        FutureUtils.addListener(this.conn.getLocator().getRegionLocation(this.tableName, this.row, this.replicaId, this.locateType, locateTimeoutNs), (loc, error) -> {
            if (error != null) {
                this.onError((Throwable)error, () -> "Locate '" + Bytes.toStringBinary(this.row) + "' in " + this.tableName + " failed", err -> {});
                return;
            }
            this.call((HRegionLocation)loc);
        });
    }

    @Override
    protected Optional<TableName> getTableName() {
        return Optional.of(this.tableName);
    }

    @FunctionalInterface
    public static interface Callable<T> {
        public CompletableFuture<T> call(HBaseRpcController var1, HRegionLocation var2, ClientProtos.ClientService.Interface var3);
    }
}

