/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hudi.org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class BalancerDecision
extends LogEntry {
    private final String initialFunctionCosts;
    private final String finalFunctionCosts;
    private final double initTotalCost;
    private final double computedTotalCost;
    private final long computedSteps;
    private final List<String> regionPlans;
    private static final Gson GSON = GsonUtil.createGson().setPrettyPrinting().registerTypeAdapter(BalancerDecision.class, (balancerDecision, type2, jsonSerializationContext) -> {
        Gson gson = new Gson();
        return gson.toJsonTree(balancerDecision);
    }).create();

    private BalancerDecision(String initialFunctionCosts, String finalFunctionCosts, double initTotalCost, double computedTotalCost, List<String> regionPlans, long computedSteps) {
        this.initialFunctionCosts = initialFunctionCosts;
        this.finalFunctionCosts = finalFunctionCosts;
        this.initTotalCost = initTotalCost;
        this.computedTotalCost = computedTotalCost;
        this.regionPlans = regionPlans;
        this.computedSteps = computedSteps;
    }

    public String getInitialFunctionCosts() {
        return this.initialFunctionCosts;
    }

    public String getFinalFunctionCosts() {
        return this.finalFunctionCosts;
    }

    public double getInitTotalCost() {
        return this.initTotalCost;
    }

    public double getComputedTotalCost() {
        return this.computedTotalCost;
    }

    public List<String> getRegionPlans() {
        return this.regionPlans;
    }

    public long getComputedSteps() {
        return this.computedSteps;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("initialFunctionCosts", (Object)this.initialFunctionCosts).append("finalFunctionCosts", (Object)this.finalFunctionCosts).append("initTotalCost", this.initTotalCost).append("computedTotalCost", this.computedTotalCost).append("computedSteps", this.computedSteps).append("regionPlans", this.regionPlans).toString();
    }

    @Override
    public String toJsonPrettyPrint() {
        return GSON.toJson((Object)this);
    }

    public static class Builder {
        private String initialFunctionCosts;
        private String finalFunctionCosts;
        private double initTotalCost;
        private double computedTotalCost;
        private long computedSteps;
        private List<String> regionPlans;

        public Builder setInitialFunctionCosts(String initialFunctionCosts) {
            this.initialFunctionCosts = initialFunctionCosts;
            return this;
        }

        public Builder setFinalFunctionCosts(String finalFunctionCosts) {
            this.finalFunctionCosts = finalFunctionCosts;
            return this;
        }

        public Builder setInitTotalCost(double initTotalCost) {
            this.initTotalCost = initTotalCost;
            return this;
        }

        public Builder setComputedTotalCost(double computedTotalCost) {
            this.computedTotalCost = computedTotalCost;
            return this;
        }

        public Builder setRegionPlans(List<String> regionPlans) {
            this.regionPlans = regionPlans;
            return this;
        }

        public Builder setComputedSteps(long computedSteps) {
            this.computedSteps = computedSteps;
            return this;
        }

        public BalancerDecision build() {
            return new BalancerDecision(this.initialFunctionCosts, this.finalFunctionCosts, this.initTotalCost, this.computedTotalCost, this.regionPlans, this.computedSteps);
        }
    }
}

