/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hudi.org.apache.hadoop.hbase.client.Action;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class MultiAction {
    protected Map<byte[], List<Action>> actions = new TreeMap<byte[], List<Action>>(Bytes.BYTES_COMPARATOR);
    private long nonceGroup = 0L;

    public int size() {
        int size = 0;
        for (List<Action> l : this.actions.values()) {
            size += l.size();
        }
        return size;
    }

    public void add(byte[] regionName, Action a) {
        this.add(regionName, Collections.singletonList(a));
    }

    public void add(byte[] regionName, List<Action> actionList) {
        List<Action> rsActions = this.actions.get(regionName);
        if (rsActions == null) {
            rsActions = new ArrayList<Action>(actionList.size());
            this.actions.put(regionName, rsActions);
        }
        rsActions.addAll(actionList);
    }

    public void setNonceGroup(long nonceGroup) {
        this.nonceGroup = nonceGroup;
    }

    public Set<byte[]> getRegions() {
        return this.actions.keySet();
    }

    public boolean hasNonceGroup() {
        return this.nonceGroup != 0L;
    }

    public long getNonceGroup() {
        return this.nonceGroup;
    }

    public int getPriority() {
        Optional result2 = this.actions.values().stream().flatMap(Collection::stream).max((action1, action2) -> Math.max(action1.getPriority(), action2.getPriority()));
        return result2.isPresent() ? ((Action)result2.get()).getPriority() : -1;
    }
}

