/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hudi.org.apache.hadoop.hbase.client.AbstractResponse;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MultiResponse
extends AbstractResponse {
    private Map<byte[], RegionResult> results = new TreeMap<byte[], RegionResult>(Bytes.BYTES_COMPARATOR);
    private Map<byte[], Throwable> exceptions = new TreeMap<byte[], Throwable>(Bytes.BYTES_COMPARATOR);

    public int size() {
        int size = 0;
        for (RegionResult result2 : this.results.values()) {
            size += result2.size();
        }
        return size;
    }

    public void add(byte[] regionName, int originalIndex, Object resOrEx) {
        this.getResult(regionName).addResult(originalIndex, resOrEx);
    }

    public void addException(byte[] regionName, Throwable ie) {
        this.exceptions.put(regionName, ie);
    }

    public Throwable getException(byte[] regionName) {
        return this.exceptions.get(regionName);
    }

    public Map<byte[], Throwable> getExceptions() {
        return this.exceptions;
    }

    public void addStatistic(byte[] regionName, ClientProtos.RegionLoadStats stat) {
        this.getResult(regionName).setStat(stat);
    }

    private RegionResult getResult(byte[] region) {
        RegionResult rs = this.results.get(region);
        if (rs == null) {
            rs = new RegionResult();
            this.results.put(region, rs);
        }
        return rs;
    }

    public Map<byte[], RegionResult> getResults() {
        return this.results;
    }

    @Override
    public AbstractResponse.ResponseType type() {
        return AbstractResponse.ResponseType.MULTI;
    }

    static class RegionResult {
        Map<Integer, Object> result = new HashMap<Integer, Object>();
        ClientProtos.RegionLoadStats stat;

        RegionResult() {
        }

        public void addResult(int index, Object result2) {
            this.result.put(index, result2);
        }

        public void setStat(ClientProtos.RegionLoadStats stat) {
            this.stat = stat;
        }

        public int size() {
            return this.result.size();
        }

        public ClientProtos.RegionLoadStats getStat() {
            return this.stat;
        }
    }
}

