/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CompareOperator;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hudi.org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RowFilter
extends CompareFilter {
    private boolean filterOutRow = false;

    @Deprecated
    public RowFilter(CompareFilter.CompareOp rowCompareOp, ByteArrayComparable rowComparator) {
        super(rowCompareOp, rowComparator);
    }

    public RowFilter(CompareOperator op, ByteArrayComparable rowComparator) {
        super(op, rowComparator);
    }

    @Override
    public void reset() {
        this.filterOutRow = false;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell v) {
        if (this.filterOutRow) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRowKey(Cell firstRowCell) {
        if (this.compareRow(this.getCompareOperator(), this.comparator, firstRowCell)) {
            this.filterOutRow = true;
        }
        return this.filterOutRow;
    }

    @Override
    public boolean filterRow() {
        return this.filterOutRow;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        ArrayList<Object> arguments2 = CompareFilter.extractArguments(filterArguments);
        CompareOperator compareOp = (CompareOperator)((Object)arguments2.get(0));
        ByteArrayComparable comparator = (ByteArrayComparable)arguments2.get(1);
        return new RowFilter(compareOp, comparator);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.RowFilter.Builder builder = FilterProtos.RowFilter.newBuilder();
        builder.setCompareFilter(super.convert());
        return builder.build().toByteArray();
    }

    public static RowFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.RowFilter proto;
        try {
            proto = FilterProtos.RowFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        CompareOperator valueCompareOp = CompareOperator.valueOf(proto.getCompareFilter().getCompareOp().name());
        ByteArrayComparable valueComparator = null;
        try {
            if (proto.getCompareFilter().hasComparator()) {
                valueComparator = ProtobufUtil.toComparator(proto.getCompareFilter().getComparator());
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new RowFilter(valueCompareOp, valueComparator);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RowFilter)) {
            return false;
        }
        return super.areSerializedFieldsEqual(o);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

