/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.crypto;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.aes.CommonsCryptoAES;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class CryptoCipherProvider
implements CipherProvider {
    private static CryptoCipherProvider instance;
    private Configuration conf = HBaseConfiguration.create();

    public static CryptoCipherProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new CryptoCipherProvider();
        return instance;
    }

    private CryptoCipherProvider() {
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public String getName() {
        return "commons";
    }

    @Override
    public Cipher getCipher(String name2) {
        if (name2.equalsIgnoreCase("AES")) {
            return new CommonsCryptoAES(this);
        }
        throw new RuntimeException("Cipher '" + name2 + "' is not supported by provider '" + this.getName() + "'");
    }

    @Override
    public String[] getSupportedCiphers() {
        return new String[]{"AES"};
    }
}

