/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.locking;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.util.NonceKey;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class LockManager {
    private static final Logger LOG = LoggerFactory.getLogger(LockManager.class);
    private final HMaster master;
    private final RemoteLocks remoteLocks;

    public LockManager(HMaster master) {
        this.master = master;
        this.remoteLocks = new RemoteLocks();
    }

    public RemoteLocks remoteLocks() {
        return this.remoteLocks;
    }

    public MasterLock createMasterLock(String namespace, LockType type2, String description2) {
        return new MasterLock(namespace, type2, description2);
    }

    public MasterLock createMasterLock(TableName tableName, LockType type2, String description2) {
        return new MasterLock(tableName, type2, description2);
    }

    public MasterLock createMasterLock(RegionInfo[] regionInfos, String description2) {
        return new MasterLock(regionInfos, description2);
    }

    private void submitProcedure(LockProcedure proc, NonceKey nonceKey) {
        proc.setOwner(((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment()).getRequestUser());
        this.master.getMasterProcedureExecutor().submitProcedure((Procedure)proc, nonceKey);
    }

    public class RemoteLocks {
        public long requestNamespaceLock(String namespace, LockType type2, String description2, NonceKey nonceKey) throws IllegalArgumentException, IOException {
            LockManager.this.master.getMasterCoprocessorHost().preRequestLock(namespace, null, null, type2, description2);
            LockProcedure proc = new LockProcedure(LockManager.this.master.getConfiguration(), namespace, type2, description2, null);
            LockManager.this.submitProcedure(proc, nonceKey);
            LockManager.this.master.getMasterCoprocessorHost().postRequestLock(namespace, null, null, type2, description2);
            return proc.getProcId();
        }

        public long requestTableLock(TableName tableName, LockType type2, String description2, NonceKey nonceKey) throws IllegalArgumentException, IOException {
            LockManager.this.master.getMasterCoprocessorHost().preRequestLock(null, tableName, null, type2, description2);
            LockProcedure proc = new LockProcedure(LockManager.this.master.getConfiguration(), tableName, type2, description2, null);
            LockManager.this.submitProcedure(proc, nonceKey);
            LockManager.this.master.getMasterCoprocessorHost().postRequestLock(null, tableName, null, type2, description2);
            return proc.getProcId();
        }

        public long requestRegionsLock(RegionInfo[] regionInfos, String description2, NonceKey nonceKey) throws IllegalArgumentException, IOException {
            LockManager.this.master.getMasterCoprocessorHost().preRequestLock(null, null, regionInfos, LockType.EXCLUSIVE, description2);
            LockProcedure proc = new LockProcedure(LockManager.this.master.getConfiguration(), regionInfos, LockType.EXCLUSIVE, description2, null);
            LockManager.this.submitProcedure(proc, nonceKey);
            LockManager.this.master.getMasterCoprocessorHost().postRequestLock(null, null, regionInfos, LockType.EXCLUSIVE, description2);
            return proc.getProcId();
        }

        public boolean lockHeartbeat(long procId, boolean keepAlive) throws IOException {
            LockProcedure proc = (LockProcedure)LockManager.this.master.getMasterProcedureExecutor().getProcedure(LockProcedure.class, procId);
            if (proc == null) {
                return false;
            }
            LockManager.this.master.getMasterCoprocessorHost().preLockHeartbeat(proc, keepAlive);
            proc.updateHeartBeat();
            if (!keepAlive) {
                proc.unlock((MasterProcedureEnv)LockManager.this.master.getMasterProcedureExecutor().getEnvironment());
            }
            LockManager.this.master.getMasterCoprocessorHost().postLockHeartbeat(proc, keepAlive);
            return proc.isLocked();
        }
    }

    public class MasterLock {
        private final String namespace;
        private final TableName tableName;
        private final RegionInfo[] regionInfos;
        private final LockType type;
        private final String description;
        private LockProcedure proc = null;

        public MasterLock(String namespace, LockType type2, String description2) {
            this.namespace = namespace;
            this.tableName = null;
            this.regionInfos = null;
            this.type = type2;
            this.description = description2;
        }

        public MasterLock(TableName tableName, LockType type2, String description2) {
            this.namespace = null;
            this.tableName = tableName;
            this.regionInfos = null;
            this.type = type2;
            this.description = description2;
        }

        public MasterLock(RegionInfo[] regionInfos, String description2) {
            this.namespace = null;
            this.tableName = null;
            this.regionInfos = regionInfos;
            this.type = LockType.EXCLUSIVE;
            this.description = description2;
        }

        public boolean acquire() throws InterruptedException {
            return this.tryAcquire(0L);
        }

        public boolean tryAcquire(long timeoutMs) throws InterruptedException {
            long deadline;
            if (this.proc != null && this.proc.isLocked()) {
                return true;
            }
            CountDownLatch lockAcquireLatch = new CountDownLatch(1);
            if (this.regionInfos != null) {
                this.proc = new LockProcedure(LockManager.this.master.getConfiguration(), this.regionInfos, this.type, this.description, lockAcquireLatch);
            } else if (this.tableName != null) {
                this.proc = new LockProcedure(LockManager.this.master.getConfiguration(), this.tableName, this.type, this.description, lockAcquireLatch);
            } else if (this.namespace != null) {
                this.proc = new LockProcedure(LockManager.this.master.getConfiguration(), this.namespace, this.type, this.description, lockAcquireLatch);
            } else {
                throw new UnsupportedOperationException("no namespace/table/region provided");
            }
            this.proc.setOwner(((MasterProcedureEnv)LockManager.this.master.getMasterProcedureExecutor().getEnvironment()).getRequestUser());
            LockManager.this.master.getMasterProcedureExecutor().submitProcedure((Procedure)this.proc);
            long l = deadline = timeoutMs > 0L ? System.currentTimeMillis() + timeoutMs : Long.MAX_VALUE;
            while (deadline >= System.currentTimeMillis() && !this.proc.isLocked()) {
                try {
                    lockAcquireLatch.await(deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOG.info("InterruptedException when waiting for lock: " + this.proc.toString());
                    this.release();
                    throw e;
                }
            }
            if (!this.proc.isLocked()) {
                LOG.info("Timed out waiting to acquire procedure lock: " + this.proc.toString());
                this.release();
                return false;
            }
            return true;
        }

        public void release() {
            if (this.proc != null) {
                this.proc.unlock((MasterProcedureEnv)LockManager.this.master.getMasterProcedureExecutor().getEnvironment());
            }
            this.proc = null;
        }

        public String toString() {
            return "MasterLock: proc = " + this.proc.toString();
        }

        LockProcedure getProc() {
            return this.proc;
        }
    }
}

