/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufMessageConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.JRubyFormat;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureDescriber {
    private ProcedureDescriber() {
    }

    private static Object parametersToObject(Procedure<?> proc) {
        try {
            ProcedureProtos.Procedure protoProc = ProcedureUtil.convertToProtoProcedure(proc);
            List parameters2 = protoProc.getStateMessageList().stream().map(any2 -> {
                try {
                    return ProtobufMessageConverter.toJavaObject(any2);
                }
                catch (InvalidProtocolBufferException e) {
                    return e.toString();
                }
            }).collect(Collectors.toList());
            return parameters2;
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public static String describe(Procedure<?> proc) {
        LinkedHashMap<String, Object> description2 = new LinkedHashMap<String, Object>();
        description2.put("ID", proc.getProcId());
        description2.put("PARENT_ID", proc.getParentProcId());
        description2.put("STATE", proc.getState());
        description2.put("OWNER", proc.getOwner());
        description2.put("TYPE", proc.getProcName());
        description2.put("START_TIME", new Date(proc.getSubmittedTime()));
        description2.put("LAST_UPDATE", new Date(proc.getLastUpdate()));
        if (proc.isFailed()) {
            description2.put("ERRORS", MasterProcedureUtil.unwrapRemoteIOException(proc).getMessage());
        }
        description2.put("PARAMETERS", ProcedureDescriber.parametersToObject(proc));
        return JRubyFormat.print(description2);
    }

    public static String describeParameters(Procedure<?> proc) {
        Object object = ProcedureDescriber.parametersToObject(proc);
        return JRubyFormat.print(object);
    }
}

