/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hudi.org.apache.hadoop.hbase.master.replication.ModifyPeerProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AddPeerProcedure
extends ModifyPeerProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(AddPeerProcedure.class);
    private ReplicationPeerConfig peerConfig;
    private boolean enabled;

    public AddPeerProcedure() {
    }

    public AddPeerProcedure(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) {
        super(peerId);
        this.peerConfig = peerConfig;
        this.enabled = enabled;
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.ADD;
    }

    @Override
    protected MasterProcedureProtos.PeerModificationState nextStateAfterRefresh() {
        return this.peerConfig.isSerial() ? MasterProcedureProtos.PeerModificationState.SERIAL_PEER_REOPEN_REGIONS : super.nextStateAfterRefresh();
    }

    @Override
    protected void updateLastPushedSequenceIdForSerialPeer(MasterProcedureEnv env) throws IOException, ReplicationException {
        this.setLastPushedSequenceId(env, this.peerConfig);
    }

    @Override
    protected boolean enablePeerBeforeFinish() {
        return this.enabled;
    }

    @Override
    protected ReplicationPeerConfig getNewPeerConfig() {
        return this.peerConfig;
    }

    @Override
    protected void prePeerModification(MasterProcedureEnv env) throws IOException, ReplicationException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preAddReplicationPeer(this.peerId, this.peerConfig);
        }
        env.getReplicationPeerManager().preAddPeer(this.peerId, this.peerConfig);
    }

    @Override
    protected void updatePeerStorage(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().addPeer(this.peerId, this.peerConfig, this.peerConfig.isSerial() ? false : this.enabled);
    }

    @Override
    protected void postPeerModification(MasterProcedureEnv env) throws IOException, ReplicationException {
        LOG.info("Successfully added {} peer {}, config {}", new Object[]{this.enabled ? "ENABLED" : "DISABLED", this.peerId, this.peerConfig});
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            env.getMasterCoprocessorHost().postAddReplicationPeer(this.peerId, this.peerConfig);
        }
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.AddPeerStateData.newBuilder().setPeerConfig(ReplicationPeerConfigUtil.convert(this.peerConfig)).setEnabled(this.enabled).build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.AddPeerStateData data2 = (MasterProcedureProtos.AddPeerStateData)serializer.deserialize(MasterProcedureProtos.AddPeerStateData.class);
        this.peerConfig = ReplicationPeerConfigUtil.convert(data2.getPeerConfig());
        this.enabled = data2.getEnabled();
    }
}

