/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CompareOperator;
import org.apache.hudi.org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.Delete;
import org.apache.hudi.org.apache.hadoop.hbase.client.Get;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hudi.org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hudi.org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hudi.org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaTableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaTableUtil.class);
    public static final TableName QUOTA_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "quota");
    protected static final byte[] QUOTA_FAMILY_INFO = Bytes.toBytes("q");
    protected static final byte[] QUOTA_FAMILY_USAGE = Bytes.toBytes("u");
    protected static final byte[] QUOTA_QUALIFIER_SETTINGS = Bytes.toBytes("s");
    protected static final byte[] QUOTA_QUALIFIER_SETTINGS_PREFIX = Bytes.toBytes("s.");
    protected static final byte[] QUOTA_QUALIFIER_POLICY = Bytes.toBytes("p");
    protected static final byte[] QUOTA_SNAPSHOT_SIZE_QUALIFIER = Bytes.toBytes("ss");
    protected static final String QUOTA_POLICY_COLUMN = Bytes.toString(QUOTA_FAMILY_USAGE) + ":" + Bytes.toString(QUOTA_QUALIFIER_POLICY);
    protected static final byte[] QUOTA_USER_ROW_KEY_PREFIX = Bytes.toBytes("u.");
    protected static final byte[] QUOTA_TABLE_ROW_KEY_PREFIX = Bytes.toBytes("t.");
    protected static final byte[] QUOTA_NAMESPACE_ROW_KEY_PREFIX = Bytes.toBytes("n.");
    protected static final byte[] QUOTA_REGION_SERVER_ROW_KEY_PREFIX = Bytes.toBytes("r.");
    private static final byte[] QUOTA_EXCEED_THROTTLE_QUOTA_ROW_KEY = Bytes.toBytes("exceedThrottleQuota");
    public static final String QUOTA_REGION_SERVER_ROW_KEY = "all";

    public static QuotaProtos.Quotas getTableQuota(Connection connection, TableName table) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getTableRowKey(table));
    }

    public static QuotaProtos.Quotas getNamespaceQuota(Connection connection, String namespace) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getNamespaceRowKey(namespace));
    }

    public static QuotaProtos.Quotas getUserQuota(Connection connection, String user) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getUserRowKey(user));
    }

    public static QuotaProtos.Quotas getUserQuota(Connection connection, String user, TableName table) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getUserRowKey(user), QuotaTableUtil.getSettingsQualifierForUserTable(table));
    }

    public static QuotaProtos.Quotas getUserQuota(Connection connection, String user, String namespace) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getUserRowKey(user), QuotaTableUtil.getSettingsQualifierForUserNamespace(namespace));
    }

    private static QuotaProtos.Quotas getQuotas(Connection connection, byte[] rowKey) throws IOException {
        return QuotaTableUtil.getQuotas(connection, rowKey, QUOTA_QUALIFIER_SETTINGS);
    }

    public static QuotaProtos.Quotas getRegionServerQuota(Connection connection, String regionServer) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getRegionServerRowKey(regionServer));
    }

    private static QuotaProtos.Quotas getQuotas(Connection connection, byte[] rowKey, byte[] qualifier) throws IOException {
        Get get2 = new Get(rowKey);
        get2.addColumn(QUOTA_FAMILY_INFO, qualifier);
        Result result2 = QuotaTableUtil.doGet(connection, get2);
        if (result2.isEmpty()) {
            return null;
        }
        return QuotaTableUtil.quotasFromData(result2.getValue(QUOTA_FAMILY_INFO, qualifier));
    }

    public static Get makeGetForTableQuotas(TableName table) {
        Get get2 = new Get(QuotaTableUtil.getTableRowKey(table));
        get2.addFamily(QUOTA_FAMILY_INFO);
        return get2;
    }

    public static Get makeGetForNamespaceQuotas(String namespace) {
        Get get2 = new Get(QuotaTableUtil.getNamespaceRowKey(namespace));
        get2.addFamily(QUOTA_FAMILY_INFO);
        return get2;
    }

    public static Get makeGetForRegionServerQuotas(String regionServer) {
        Get get2 = new Get(QuotaTableUtil.getRegionServerRowKey(regionServer));
        get2.addFamily(QUOTA_FAMILY_INFO);
        return get2;
    }

    public static Get makeGetForUserQuotas(String user, Iterable<TableName> tables, Iterable<String> namespaces) {
        Get get2 = new Get(QuotaTableUtil.getUserRowKey(user));
        get2.addColumn(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        for (TableName table : tables) {
            get2.addColumn(QUOTA_FAMILY_INFO, QuotaTableUtil.getSettingsQualifierForUserTable(table));
        }
        for (String ns : namespaces) {
            get2.addColumn(QUOTA_FAMILY_INFO, QuotaTableUtil.getSettingsQualifierForUserNamespace(ns));
        }
        return get2;
    }

    public static Scan makeScan(QuotaFilter filter) {
        Scan scan = new Scan();
        scan.addFamily(QUOTA_FAMILY_INFO);
        if (filter != null && !filter.isNull()) {
            scan.setFilter(QuotaTableUtil.makeFilter(filter));
        }
        return scan;
    }

    public static Filter makeFilter(QuotaFilter filter) {
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        if (StringUtils.isNotEmpty((CharSequence)filter.getUserFilter())) {
            FilterList userFilters = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            boolean hasFilter = false;
            if (StringUtils.isNotEmpty((CharSequence)filter.getNamespaceFilter())) {
                FilterList nsFilters = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                nsFilters.addFilter(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(QuotaTableUtil.getUserRowKeyRegex(filter.getUserFilter()), 0)));
                nsFilters.addFilter(new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(QuotaTableUtil.getSettingsQualifierRegexForUserNamespace(filter.getNamespaceFilter()), 0)));
                userFilters.addFilter(nsFilters);
                hasFilter = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)filter.getTableFilter())) {
                FilterList tableFilters = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                tableFilters.addFilter(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(QuotaTableUtil.getUserRowKeyRegex(filter.getUserFilter()), 0)));
                tableFilters.addFilter(new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(QuotaTableUtil.getSettingsQualifierRegexForUserTable(filter.getTableFilter()), 0)));
                userFilters.addFilter(tableFilters);
                hasFilter = true;
            }
            if (!hasFilter) {
                userFilters.addFilter(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(QuotaTableUtil.getUserRowKeyRegex(filter.getUserFilter()), 0)));
            }
            filterList.addFilter(userFilters);
        } else if (StringUtils.isNotEmpty((CharSequence)filter.getTableFilter())) {
            filterList.addFilter(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(QuotaTableUtil.getTableRowKeyRegex(filter.getTableFilter()), 0)));
        } else if (StringUtils.isNotEmpty((CharSequence)filter.getNamespaceFilter())) {
            filterList.addFilter(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(QuotaTableUtil.getNamespaceRowKeyRegex(filter.getNamespaceFilter()), 0)));
        } else if (StringUtils.isNotEmpty((CharSequence)filter.getRegionServerFilter())) {
            filterList.addFilter(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(QuotaTableUtil.getRegionServerRowKeyRegex(filter.getRegionServerFilter()), 0)));
        }
        return filterList;
    }

    public static Scan makeQuotaSnapshotScan() {
        return QuotaTableUtil.makeQuotaSnapshotScanForTable(null);
    }

    public static Map<TableName, SpaceQuotaSnapshot> getSnapshots(Connection conn) throws IOException {
        HashMap<TableName, SpaceQuotaSnapshot> snapshots = new HashMap<TableName, SpaceQuotaSnapshot>();
        try (Table quotaTable = conn.getTable(QUOTA_TABLE_NAME);
             ResultScanner rs = quotaTable.getScanner(QuotaTableUtil.makeQuotaSnapshotScan());){
            for (Result r : rs) {
                QuotaTableUtil.extractQuotaSnapshot(r, snapshots);
            }
        }
        return snapshots;
    }

    public static Scan makeQuotaSnapshotScanForTable(TableName tn) {
        Scan s = new Scan();
        s.addColumn(QUOTA_FAMILY_USAGE, QUOTA_QUALIFIER_POLICY);
        if (null == tn) {
            s.setRowPrefixFilter(QUOTA_TABLE_ROW_KEY_PREFIX);
        } else {
            byte[] row = QuotaTableUtil.getTableRowKey(tn);
            s.withStartRow(row, true).withStopRow(row, true);
        }
        return s;
    }

    public static Get makeQuotaSnapshotGetForTable(TableName tn) {
        Get g = new Get(QuotaTableUtil.getTableRowKey(tn));
        g.addColumn(QUOTA_FAMILY_USAGE, QUOTA_QUALIFIER_POLICY);
        return g;
    }

    public static void extractQuotaSnapshot(Result result2, Map<TableName, SpaceQuotaSnapshot> snapshots) {
        byte[] row = Objects.requireNonNull(result2).getRow();
        if (row == null || row.length == 0) {
            throw new IllegalArgumentException("Provided result had a null row");
        }
        TableName targetTableName = QuotaTableUtil.getTableFromRowKey(row);
        Cell c = result2.getColumnLatestCell(QUOTA_FAMILY_USAGE, QUOTA_QUALIFIER_POLICY);
        if (c == null) {
            throw new IllegalArgumentException("Result did not contain the expected column " + QUOTA_POLICY_COLUMN + ", " + result2.toString());
        }
        ByteString buffer = UnsafeByteOperations.unsafeWrap(c.getValueArray(), c.getValueOffset(), c.getValueLength());
        try {
            QuotaProtos.SpaceQuotaSnapshot snapshot = QuotaProtos.SpaceQuotaSnapshot.parseFrom(buffer);
            snapshots.put(targetTableName, SpaceQuotaSnapshot.toSpaceQuotaSnapshot(snapshot));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Result did not contain a valid SpaceQuota protocol buffer message", e);
        }
    }

    public static void parseResult(Result result2, QuotasVisitor visitor2) throws IOException {
        byte[] row = result2.getRow();
        if (QuotaTableUtil.isNamespaceRowKey(row)) {
            QuotaTableUtil.parseNamespaceResult(result2, visitor2);
        } else if (QuotaTableUtil.isTableRowKey(row)) {
            QuotaTableUtil.parseTableResult(result2, visitor2);
        } else if (QuotaTableUtil.isUserRowKey(row)) {
            QuotaTableUtil.parseUserResult(result2, visitor2);
        } else if (QuotaTableUtil.isRegionServerRowKey(row)) {
            QuotaTableUtil.parseRegionServerResult(result2, visitor2);
        } else if (QuotaTableUtil.isExceedThrottleQuotaRowKey(row)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skip exceedThrottleQuota row-key when parse quota result");
            }
        } else {
            LOG.warn("unexpected row-key: " + Bytes.toString(row));
        }
    }

    public static void parseResultToCollection(Result result2, final Collection<QuotaSettings> quotaSettings) throws IOException {
        QuotaTableUtil.parseResult(result2, new QuotasVisitor(){

            @Override
            public void visitUserQuotas(String userName, QuotaProtos.Quotas quotas) {
                quotaSettings.addAll(QuotaSettingsFactory.fromUserQuotas(userName, quotas));
            }

            @Override
            public void visitUserQuotas(String userName, TableName table, QuotaProtos.Quotas quotas) {
                quotaSettings.addAll(QuotaSettingsFactory.fromUserQuotas(userName, table, quotas));
            }

            @Override
            public void visitUserQuotas(String userName, String namespace, QuotaProtos.Quotas quotas) {
                quotaSettings.addAll(QuotaSettingsFactory.fromUserQuotas(userName, namespace, quotas));
            }

            @Override
            public void visitTableQuotas(TableName tableName, QuotaProtos.Quotas quotas) {
                quotaSettings.addAll(QuotaSettingsFactory.fromTableQuotas(tableName, quotas));
            }

            @Override
            public void visitNamespaceQuotas(String namespace, QuotaProtos.Quotas quotas) {
                quotaSettings.addAll(QuotaSettingsFactory.fromNamespaceQuotas(namespace, quotas));
            }

            @Override
            public void visitRegionServerQuotas(String regionServer, QuotaProtos.Quotas quotas) {
                quotaSettings.addAll(QuotaSettingsFactory.fromRegionServerQuotas(regionServer, quotas));
            }
        });
    }

    public static void parseNamespaceResult(Result result2, NamespaceQuotasVisitor visitor2) throws IOException {
        String namespace = QuotaTableUtil.getNamespaceFromRowKey(result2.getRow());
        QuotaTableUtil.parseNamespaceResult(namespace, result2, visitor2);
    }

    protected static void parseNamespaceResult(String namespace, Result result2, NamespaceQuotasVisitor visitor2) throws IOException {
        byte[] data2 = result2.getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        if (data2 != null) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData(data2);
            visitor2.visitNamespaceQuotas(namespace, quotas);
        }
    }

    private static void parseRegionServerResult(Result result2, RegionServerQuotasVisitor visitor2) throws IOException {
        String rs = QuotaTableUtil.getRegionServerFromRowKey(result2.getRow());
        QuotaTableUtil.parseRegionServerResult(rs, result2, visitor2);
    }

    private static void parseRegionServerResult(String regionServer, Result result2, RegionServerQuotasVisitor visitor2) throws IOException {
        byte[] data2 = result2.getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        if (data2 != null) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData(data2);
            visitor2.visitRegionServerQuotas(regionServer, quotas);
        }
    }

    public static void parseTableResult(Result result2, TableQuotasVisitor visitor2) throws IOException {
        TableName table = QuotaTableUtil.getTableFromRowKey(result2.getRow());
        QuotaTableUtil.parseTableResult(table, result2, visitor2);
    }

    protected static void parseTableResult(TableName table, Result result2, TableQuotasVisitor visitor2) throws IOException {
        byte[] data2 = result2.getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        if (data2 != null) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData(data2);
            visitor2.visitTableQuotas(table, quotas);
        }
    }

    public static void parseUserResult(Result result2, UserQuotasVisitor visitor2) throws IOException {
        String userName = QuotaTableUtil.getUserFromRowKey(result2.getRow());
        QuotaTableUtil.parseUserResult(userName, result2, visitor2);
    }

    protected static void parseUserResult(String userName, Result result2, UserQuotasVisitor visitor2) throws IOException {
        NavigableMap<byte[], byte[]> familyMap = result2.getFamilyMap(QUOTA_FAMILY_INFO);
        if (familyMap == null || familyMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : familyMap.entrySet()) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData((byte[])entry.getValue());
            if (Bytes.startsWith((byte[])entry.getKey(), QUOTA_QUALIFIER_SETTINGS_PREFIX)) {
                String name2 = Bytes.toString((byte[])entry.getKey(), QUOTA_QUALIFIER_SETTINGS_PREFIX.length);
                if (name2.charAt(name2.length() - 1) == ':') {
                    String namespace = name2.substring(0, name2.length() - 1);
                    visitor2.visitUserQuotas(userName, namespace, quotas);
                    continue;
                }
                TableName table = TableName.valueOf(name2);
                visitor2.visitUserQuotas(userName, table, quotas);
                continue;
            }
            if (!Bytes.equals((byte[])entry.getKey(), QUOTA_QUALIFIER_SETTINGS)) continue;
            visitor2.visitUserQuotas(userName, quotas);
        }
    }

    static Put createPutForSpaceSnapshot(TableName tableName, SpaceQuotaSnapshot snapshot) {
        Put p = new Put(QuotaTableUtil.getTableRowKey(tableName));
        p.addColumn(QUOTA_FAMILY_USAGE, QUOTA_QUALIFIER_POLICY, SpaceQuotaSnapshot.toProtoSnapshot(snapshot).toByteArray());
        return p;
    }

    static Get makeGetForSnapshotSize(TableName tn, String snapshot) {
        Get g = new Get(Bytes.add(QUOTA_TABLE_ROW_KEY_PREFIX, Bytes.toBytes(tn.toString())));
        g.addColumn(QUOTA_FAMILY_USAGE, Bytes.add(QUOTA_SNAPSHOT_SIZE_QUALIFIER, Bytes.toBytes(snapshot)));
        return g;
    }

    static Put createPutForSnapshotSize(TableName tableName, String snapshot, long size) {
        Put p = new Put(QuotaTableUtil.getTableRowKey(tableName));
        p.addColumn(QUOTA_FAMILY_USAGE, QuotaTableUtil.getSnapshotSizeQualifier(snapshot), QuotaProtos.SpaceQuotaSnapshot.newBuilder().setQuotaUsage(size).build().toByteArray());
        return p;
    }

    static Put createPutForNamespaceSnapshotSize(String namespace, long size) {
        Put p = new Put(QuotaTableUtil.getNamespaceRowKey(namespace));
        p.addColumn(QUOTA_FAMILY_USAGE, QUOTA_SNAPSHOT_SIZE_QUALIFIER, QuotaProtos.SpaceQuotaSnapshot.newBuilder().setQuotaUsage(size).build().toByteArray());
        return p;
    }

    static List<Delete> createDeletesForExistingTableSnapshotSizes(Multimap<TableName, String> snapshotEntriesToRemove) {
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (Map.Entry<TableName, Collection<String>> entry : snapshotEntriesToRemove.asMap().entrySet()) {
            for (String snapshot : entry.getValue()) {
                Delete d = new Delete(QuotaTableUtil.getTableRowKey(entry.getKey()));
                d.addColumns(QUOTA_FAMILY_USAGE, Bytes.add(QUOTA_SNAPSHOT_SIZE_QUALIFIER, Bytes.toBytes(snapshot)));
                deletes.add(d);
            }
        }
        return deletes;
    }

    static List<Delete> createDeletesForExistingTableSnapshotSizes(Connection connection) throws IOException {
        return QuotaTableUtil.createDeletesForExistingSnapshotsFromScan(connection, QuotaTableUtil.createScanForSpaceSnapshotSizes());
    }

    static List<Delete> createDeletesForExistingNamespaceSnapshotSizes(Set<String> snapshotEntriesToRemove) {
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (String snapshot : snapshotEntriesToRemove) {
            Delete d = new Delete(QuotaTableUtil.getNamespaceRowKey(snapshot));
            d.addColumns(QUOTA_FAMILY_USAGE, QUOTA_SNAPSHOT_SIZE_QUALIFIER);
            deletes.add(d);
        }
        return deletes;
    }

    static List<Delete> createDeletesForExistingNamespaceSnapshotSizes(Connection connection) throws IOException {
        return QuotaTableUtil.createDeletesForExistingSnapshotsFromScan(connection, QuotaTableUtil.createScanForNamespaceSnapshotSizes());
    }

    /*
     * Exception decompiling
     */
    static List<Delete> createDeletesForExistingSnapshotsFromScan(Connection connection, Scan scan) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void deleteTableUsageSnapshotsForNamespace(Connection connection, String namespace) throws IOException {
        Scan s = new Scan();
        s.setRowPrefixFilter(Bytes.add(QUOTA_TABLE_ROW_KEY_PREFIX, Bytes.toBytes(namespace + ':')));
        s.addColumn(QUOTA_FAMILY_USAGE, QUOTA_QUALIFIER_POLICY);
        s.addColumn(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        try (Table quotaTable = connection.getTable(QUOTA_TABLE_NAME);
             ResultScanner rs = quotaTable.getScanner(s);){
            for (Result r : rs) {
                byte[] data2 = r.getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
                if (data2 != null) continue;
                Delete delete = new Delete(r.getRow());
                delete.addColumns(QUOTA_FAMILY_USAGE, QUOTA_QUALIFIER_POLICY);
                quotaTable.delete(delete);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getNamespaceSnapshotSize(Connection conn, String namespace) throws IOException {
        try (Table quotaTable = conn.getTable(QUOTA_TABLE_NAME);){
            Result r = quotaTable.get(QuotaTableUtil.createGetNamespaceSnapshotSize(namespace));
            if (r.isEmpty()) {
                long l = 0L;
                return l;
            }
            r.advance();
            long l = QuotaTableUtil.parseSnapshotSize(r.current());
            return l;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException("Could not parse snapshot size value for namespace " + namespace, e);
        }
    }

    static Get createGetNamespaceSnapshotSize(String namespace) {
        Get g = new Get(QuotaTableUtil.getNamespaceRowKey(namespace));
        g.addColumn(QUOTA_FAMILY_USAGE, QUOTA_SNAPSHOT_SIZE_QUALIFIER);
        return g;
    }

    static long parseSnapshotSize(Cell c) throws InvalidProtocolBufferException {
        ByteString bs = UnsafeByteOperations.unsafeWrap(c.getValueArray(), c.getValueOffset(), c.getValueLength());
        return QuotaProtos.SpaceQuotaSnapshot.parseFrom(bs).getQuotaUsage();
    }

    static Scan createScanForNamespaceSnapshotSizes() {
        return QuotaTableUtil.createScanForNamespaceSnapshotSizes(null);
    }

    static Scan createScanForNamespaceSnapshotSizes(String namespace) {
        Scan s = new Scan();
        if (namespace == null || namespace.isEmpty()) {
            s.setRowPrefixFilter(QUOTA_NAMESPACE_ROW_KEY_PREFIX);
        } else {
            byte[] rowkey = QuotaTableUtil.getNamespaceRowKey(namespace);
            s.withStartRow(rowkey).withStopRow(rowkey, true);
        }
        return s.addFamily(QUOTA_FAMILY_USAGE).setFilter(new ColumnPrefixFilter(QUOTA_SNAPSHOT_SIZE_QUALIFIER));
    }

    static Scan createScanForSpaceSnapshotSizes() {
        return QuotaTableUtil.createScanForSpaceSnapshotSizes(null);
    }

    static Scan createScanForSpaceSnapshotSizes(TableName table) {
        Scan s = new Scan();
        if (null == table) {
            s.setRowPrefixFilter(QUOTA_TABLE_ROW_KEY_PREFIX);
        } else {
            byte[] rowkey = QuotaTableUtil.getTableRowKey(table);
            s.withStartRow(rowkey).withStopRow(rowkey, true);
        }
        return s.addFamily(QUOTA_FAMILY_USAGE).setFilter(new ColumnPrefixFilter(QUOTA_SNAPSHOT_SIZE_QUALIFIER));
    }

    /*
     * Exception decompiling
     */
    public static Map<String, Long> getObservedSnapshotSizes(Connection conn) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Multimap<TableName, String> getTableSnapshots(Connection conn) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Set<String> getNamespaceSnapshots(Connection conn) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SpaceQuotaSnapshot getCurrentSnapshotFromQuotaTable(Connection conn, TableName tableName) throws IOException {
        try (Table quotaTable = conn.getTable(QUOTA_TABLE_NAME);){
            HashMap<TableName, SpaceQuotaSnapshot> snapshots = new HashMap<TableName, SpaceQuotaSnapshot>(1);
            Result result2 = quotaTable.get(QuotaTableUtil.makeQuotaSnapshotGetForTable(tableName));
            if (result2.isEmpty()) {
                SpaceQuotaSnapshot spaceQuotaSnapshot = null;
                return spaceQuotaSnapshot;
            }
            QuotaTableUtil.extractQuotaSnapshot(result2, snapshots);
            SpaceQuotaSnapshot spaceQuotaSnapshot = (SpaceQuotaSnapshot)snapshots.get(tableName);
            return spaceQuotaSnapshot;
        }
    }

    protected static QuotaProtos.Quotas quotasFromData(byte[] data2) throws IOException {
        return QuotaTableUtil.quotasFromData(data2, 0, data2.length);
    }

    protected static QuotaProtos.Quotas quotasFromData(byte[] data2, int offset, int length) throws IOException {
        int magicLen = ProtobufMagic.lengthOfPBMagic();
        if (!ProtobufMagic.isPBMagicPrefix(data2, offset, magicLen)) {
            throw new IOException("Missing pb magic prefix");
        }
        return QuotaProtos.Quotas.parseFrom(new ByteArrayInputStream(data2, offset + magicLen, length - magicLen));
    }

    protected static byte[] quotasToData(QuotaProtos.Quotas data2) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(ProtobufMagic.PB_MAGIC);
        data2.writeTo(stream);
        return stream.toByteArray();
    }

    public static boolean isEmptyQuota(QuotaProtos.Quotas quotas) {
        boolean hasSettings = false;
        hasSettings |= quotas.hasThrottle();
        hasSettings |= quotas.hasBypassGlobals();
        if (quotas.hasSpace()) {
            hasSettings |= quotas.getSpace().hasSoftLimit() && quotas.getSpace().hasViolationPolicy();
        }
        return !hasSettings;
    }

    protected static Result doGet(Connection connection, Get get2) throws IOException {
        try (Table table = connection.getTable(QUOTA_TABLE_NAME);){
            Result result2 = table.get(get2);
            return result2;
        }
    }

    protected static Result[] doGet(Connection connection, List<Get> gets) throws IOException {
        try (Table table = connection.getTable(QUOTA_TABLE_NAME);){
            Result[] resultArray = table.get(gets);
            return resultArray;
        }
    }

    protected static byte[] getUserRowKey(String user) {
        return Bytes.add(QUOTA_USER_ROW_KEY_PREFIX, Bytes.toBytes(user));
    }

    protected static byte[] getTableRowKey(TableName table) {
        return Bytes.add(QUOTA_TABLE_ROW_KEY_PREFIX, table.getName());
    }

    protected static byte[] getNamespaceRowKey(String namespace) {
        return Bytes.add(QUOTA_NAMESPACE_ROW_KEY_PREFIX, Bytes.toBytes(namespace));
    }

    protected static byte[] getRegionServerRowKey(String regionServer) {
        return Bytes.add(QUOTA_REGION_SERVER_ROW_KEY_PREFIX, Bytes.toBytes(regionServer));
    }

    protected static byte[] getSettingsQualifierForUserTable(TableName tableName) {
        return Bytes.add(QUOTA_QUALIFIER_SETTINGS_PREFIX, tableName.getName());
    }

    protected static byte[] getSettingsQualifierForUserNamespace(String namespace) {
        return Bytes.add(QUOTA_QUALIFIER_SETTINGS_PREFIX, Bytes.toBytes(namespace + ':'));
    }

    protected static String getUserRowKeyRegex(String user) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_USER_ROW_KEY_PREFIX, user);
    }

    protected static String getTableRowKeyRegex(String table) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_TABLE_ROW_KEY_PREFIX, table);
    }

    protected static String getNamespaceRowKeyRegex(String namespace) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_NAMESPACE_ROW_KEY_PREFIX, namespace);
    }

    private static String getRegionServerRowKeyRegex(String regionServer) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_REGION_SERVER_ROW_KEY_PREFIX, regionServer);
    }

    protected static byte[] getExceedThrottleQuotaRowKey() {
        return QUOTA_EXCEED_THROTTLE_QUOTA_ROW_KEY;
    }

    private static String getRowKeyRegEx(byte[] prefix, String regex2) {
        return '^' + Pattern.quote(Bytes.toString(prefix)) + regex2 + '$';
    }

    protected static String getSettingsQualifierRegexForUserTable(String table) {
        return '^' + Pattern.quote(Bytes.toString(QUOTA_QUALIFIER_SETTINGS_PREFIX)) + table + "(?<!" + Pattern.quote(Character.toString(':')) + ")$";
    }

    protected static String getSettingsQualifierRegexForUserNamespace(String namespace) {
        return '^' + Pattern.quote(Bytes.toString(QUOTA_QUALIFIER_SETTINGS_PREFIX)) + namespace + Pattern.quote(Character.toString(':')) + '$';
    }

    protected static boolean isNamespaceRowKey(byte[] key) {
        return Bytes.startsWith(key, QUOTA_NAMESPACE_ROW_KEY_PREFIX);
    }

    protected static String getNamespaceFromRowKey(byte[] key) {
        return Bytes.toString(key, QUOTA_NAMESPACE_ROW_KEY_PREFIX.length);
    }

    protected static boolean isRegionServerRowKey(byte[] key) {
        return Bytes.startsWith(key, QUOTA_REGION_SERVER_ROW_KEY_PREFIX);
    }

    private static boolean isExceedThrottleQuotaRowKey(byte[] key) {
        return Bytes.equals(key, QUOTA_EXCEED_THROTTLE_QUOTA_ROW_KEY);
    }

    protected static String getRegionServerFromRowKey(byte[] key) {
        return Bytes.toString(key, QUOTA_REGION_SERVER_ROW_KEY_PREFIX.length);
    }

    protected static boolean isTableRowKey(byte[] key) {
        return Bytes.startsWith(key, QUOTA_TABLE_ROW_KEY_PREFIX);
    }

    protected static TableName getTableFromRowKey(byte[] key) {
        return TableName.valueOf(Bytes.toString(key, QUOTA_TABLE_ROW_KEY_PREFIX.length));
    }

    protected static boolean isUserRowKey(byte[] key) {
        return Bytes.startsWith(key, QUOTA_USER_ROW_KEY_PREFIX);
    }

    protected static String getUserFromRowKey(byte[] key) {
        return Bytes.toString(key, QUOTA_USER_ROW_KEY_PREFIX.length);
    }

    protected static QuotaProtos.SpaceQuota getProtoViolationPolicy(SpaceViolationPolicy policy) {
        return QuotaProtos.SpaceQuota.newBuilder().setViolationPolicy(ProtobufUtil.toProtoViolationPolicy(policy)).build();
    }

    protected static SpaceViolationPolicy getViolationPolicy(QuotaProtos.SpaceQuota proto) {
        if (!proto.hasViolationPolicy()) {
            throw new IllegalArgumentException("Protobuf SpaceQuota does not have violation policy.");
        }
        return ProtobufUtil.toViolationPolicy(proto.getViolationPolicy());
    }

    protected static byte[] getSnapshotSizeQualifier(String snapshotName) {
        return Bytes.add(QUOTA_SNAPSHOT_SIZE_QUALIFIER, Bytes.toBytes(snapshotName));
    }

    protected static String extractSnapshotNameFromSizeCell(Cell c) {
        return Bytes.toString(c.getQualifierArray(), c.getQualifierOffset() + QUOTA_SNAPSHOT_SIZE_QUALIFIER.length, c.getQualifierLength() - QUOTA_SNAPSHOT_SIZE_QUALIFIER.length);
    }

    protected static long extractSnapshotSize(byte[] data2, int offset, int length) throws InvalidProtocolBufferException {
        ByteString byteStr = UnsafeByteOperations.unsafeWrap(data2, offset, length);
        return QuotaProtos.SpaceQuotaSnapshot.parseFrom(byteStr).getQuotaUsage();
    }

    public static interface QuotasVisitor
    extends UserQuotasVisitor,
    TableQuotasVisitor,
    NamespaceQuotasVisitor,
    RegionServerQuotasVisitor {
    }

    private static interface RegionServerQuotasVisitor {
        public void visitRegionServerQuotas(String var1, QuotaProtos.Quotas var2) throws IOException;
    }

    public static interface NamespaceQuotasVisitor {
        public void visitNamespaceQuotas(String var1, QuotaProtos.Quotas var2) throws IOException;
    }

    public static interface TableQuotasVisitor {
        public void visitTableQuotas(TableName var1, QuotaProtos.Quotas var2) throws IOException;
    }

    public static interface UserQuotasVisitor {
        public void visitUserQuotas(String var1, QuotaProtos.Quotas var2) throws IOException;

        public void visitUserQuotas(String var1, TableName var2, QuotaProtos.Quotas var3) throws IOException;

        public void visitUserQuotas(String var1, String var2, QuotaProtos.Quotas var3) throws IOException;
    }
}

