/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.DelimitedKeyPrefixRegionSplitRestriction;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitRestriction;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.NoRegionSplitRestriction;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class RegionSplitRestriction {
    private static final Logger LOG = LoggerFactory.getLogger(RegionSplitRestriction.class);
    public static final String RESTRICTION_TYPE_KEY = "hbase.regionserver.region.split_restriction.type";
    public static final String RESTRICTION_TYPE_NONE = "None";
    public static final String RESTRICTION_TYPE_KEY_PREFIX = "KeyPrefix";
    public static final String RESTRICTION_TYPE_DELIMITED_KEY_PREFIX = "DelimitedKeyPrefix";

    public static RegionSplitRestriction create(TableDescriptor tableDescriptor, Configuration conf) throws IOException {
        RegionSplitRestriction ret;
        String type2 = tableDescriptor.getValue(RESTRICTION_TYPE_KEY);
        if (type2 == null) {
            type2 = conf.get(RESTRICTION_TYPE_KEY, RESTRICTION_TYPE_NONE);
        }
        switch (type2) {
            case "None": {
                ret = new NoRegionSplitRestriction();
                break;
            }
            case "KeyPrefix": {
                ret = new KeyPrefixRegionSplitRestriction();
                break;
            }
            case "DelimitedKeyPrefix": {
                ret = new DelimitedKeyPrefixRegionSplitRestriction();
                break;
            }
            default: {
                LOG.warn("Invalid RegionSplitRestriction type specified: {}. Using the default RegionSplitRestriction", (Object)type2);
                ret = new NoRegionSplitRestriction();
            }
        }
        ret.initialize(tableDescriptor, conf);
        return ret;
    }

    public abstract void initialize(TableDescriptor var1, Configuration var2) throws IOException;

    public abstract byte[] getRestrictedSplitPoint(byte[] var1);
}

