/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ColumnCount;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ScanWildcardColumnTracker
implements ColumnTracker {
    private Cell columnCell = null;
    private int currentCount = 0;
    private final int maxVersions;
    private final int minVersions;
    private long latestTSOfCurrentColumn;
    private byte latestTypeOfCurrentColumn;
    private long oldestStamp;
    private final CellComparator comparator;

    public ScanWildcardColumnTracker(int minVersion, int maxVersion, long oldestUnexpiredTS, CellComparator comparator) {
        this.maxVersions = maxVersion;
        this.minVersions = minVersion;
        this.oldestStamp = oldestUnexpiredTS;
        this.comparator = comparator;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkColumn(Cell cell, byte type2) throws IOException {
        return ScanQueryMatcher.MatchCode.INCLUDE;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkVersions(Cell cell, long timestamp, byte type2, boolean ignoreCount) throws IOException {
        if (this.columnCell == null) {
            this.resetCell(cell);
            if (ignoreCount) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            return this.checkVersion(type2, timestamp);
        }
        int cmp = this.comparator.compareQualifiers(cell, this.columnCell);
        if (cmp == 0) {
            if (ignoreCount) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            if (this.sameAsPreviousTSAndType(timestamp, type2)) {
                return ScanQueryMatcher.MatchCode.SKIP;
            }
            return this.checkVersion(type2, timestamp);
        }
        this.resetTSAndType();
        if (cmp > 0) {
            this.resetCell(cell);
            if (ignoreCount) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            return this.checkVersion(type2, timestamp);
        }
        throw new IOException("ScanWildcardColumnTracker.checkColumn ran into a column actually smaller than the previous column: " + Bytes.toStringBinary(CellUtil.cloneQualifier(cell)));
    }

    private void resetCell(Cell columnCell) {
        this.columnCell = columnCell;
        this.currentCount = 0;
    }

    private ScanQueryMatcher.MatchCode checkVersion(byte type2, long timestamp) {
        if (!PrivateCellUtil.isDelete(type2)) {
            ++this.currentCount;
        }
        if (this.currentCount > this.maxVersions) {
            return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
        }
        if (this.currentCount <= this.minVersions || !this.isExpired(timestamp)) {
            this.setTSAndType(timestamp, type2);
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
    }

    @Override
    public void reset() {
        this.columnCell = null;
        this.resetTSAndType();
    }

    private void resetTSAndType() {
        this.latestTSOfCurrentColumn = Long.MAX_VALUE;
        this.latestTypeOfCurrentColumn = 0;
    }

    private void setTSAndType(long timestamp, byte type2) {
        this.latestTSOfCurrentColumn = timestamp;
        this.latestTypeOfCurrentColumn = type2;
    }

    private boolean sameAsPreviousTSAndType(long timestamp, byte type2) {
        return timestamp == this.latestTSOfCurrentColumn && type2 == this.latestTypeOfCurrentColumn;
    }

    private boolean isExpired(long timestamp) {
        return timestamp < this.oldestStamp;
    }

    @Override
    public ColumnCount getColumnHint() {
        return null;
    }

    @Override
    public boolean done() {
        return false;
    }

    @Override
    public ScanQueryMatcher.MatchCode getNextRowOrNextColumn(Cell cell) {
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
    }

    @Override
    public void beforeShipped() {
        if (this.columnCell != null) {
            this.columnCell = KeyValueUtil.toNewKeyCell(this.columnCell);
        }
    }

    @Override
    public boolean isDone(long timestamp) {
        return this.minVersions <= 0 && this.isExpired(timestamp);
    }
}

