/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hudi.org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.codec.Codec;
import org.apache.hudi.org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBuffInputStream;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBufferWriter;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBufferWriterOutputStream;
import org.apache.hudi.org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hudi.org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix", "Configuration"})
public class WALCellCodec
implements Codec {
    public static final String WAL_CELL_CODEC_CLASS_KEY = "hbase.regionserver.wal.codec";
    protected final CompressionContext compression;

    public WALCellCodec() {
        this.compression = null;
    }

    public WALCellCodec(Configuration conf, CompressionContext compression) {
        this.compression = compression;
    }

    public static Class<?> getWALCellCodecClass(Configuration conf) {
        return conf.getClass(WAL_CELL_CODEC_CLASS_KEY, WALCellCodec.class);
    }

    public static WALCellCodec create(Configuration conf, String cellCodecClsName, CompressionContext compression) throws UnsupportedOperationException {
        if (cellCodecClsName == null) {
            cellCodecClsName = WALCellCodec.getWALCellCodecClass(conf).getName();
        }
        return (WALCellCodec)ReflectionUtils.instantiateWithCustomCtor(cellCodecClsName, new Class[]{Configuration.class, CompressionContext.class}, new Object[]{conf, compression});
    }

    public static WALCellCodec create(Configuration conf, CompressionContext compression) throws UnsupportedOperationException {
        String cellCodecClsName = WALCellCodec.getWALCellCodecClass(conf).getName();
        return (WALCellCodec)ReflectionUtils.instantiateWithCustomCtor(cellCodecClsName, new Class[]{Configuration.class, CompressionContext.class}, new Object[]{conf, compression});
    }

    private static byte[] uncompressByteString(ByteString bs, Dictionary dict) throws IOException {
        InputStream in = bs.newInput();
        byte status = (byte)in.read();
        if (status == -1) {
            byte[] arr = new byte[StreamUtils.readRawVarint32(in)];
            int bytesRead = in.read(arr);
            if (bytesRead != arr.length) {
                throw new IOException("Cannot read; wanted " + arr.length + ", but got " + bytesRead);
            }
            if (dict != null) {
                dict.addEntry(arr, 0, arr.length);
            }
            return arr;
        }
        short dictIdx = StreamUtils.toShort(status, (byte)in.read());
        byte[] entry = dict.getEntry(dictIdx);
        if (entry == null) {
            throw new IOException("Missing dictionary entry for index " + dictIdx);
        }
        return entry;
    }

    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return this.compression == null ? new KeyValueCodecWithTags.KeyValueDecoder(is) : new CompressedKvDecoder(is, this.compression);
    }

    @Override
    public Codec.Decoder getDecoder(ByteBuff buf) {
        return this.getDecoder(new ByteBuffInputStream(buf));
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        OutputStream outputStream = os = os instanceof ByteBufferWriter ? os : new ByteBufferWriterOutputStream(os);
        if (this.compression == null) {
            return new EnsureKvEncoder(os);
        }
        return new CompressedKvEncoder(os, this.compression);
    }

    public ByteStringCompressor getByteStringCompressor() {
        return new BaosAndCompressor(this.compression);
    }

    public ByteStringUncompressor getByteStringUncompressor() {
        return new StatelessUncompressor(this.compression);
    }

    public static ByteStringCompressor getNoneCompressor() {
        return new NoneCompressor();
    }

    public static ByteStringUncompressor getNoneUncompressor() {
        return new NoneUncompressor();
    }

    public static class EnsureKvEncoder
    extends BaseEncoder {
        public EnsureKvEncoder(OutputStream out) {
            super(out);
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            ByteBufferUtils.putInt(this.out, KeyValueUtil.getSerializedSize(cell, true));
            KeyValueUtil.oswrite(cell, this.out, true);
        }
    }

    static class CompressedKvDecoder
    extends BaseDecoder {
        private final CompressionContext compression;

        public CompressedKvDecoder(InputStream in, CompressionContext compression) {
            super(in);
            this.compression = compression;
        }

        @Override
        protected Cell parseCell() throws IOException {
            int keylength = StreamUtils.readRawVarint32(this.in);
            int vlength = StreamUtils.readRawVarint32(this.in);
            int tagsLength = StreamUtils.readRawVarint32(this.in);
            int length = 0;
            length = tagsLength == 0 ? 8 + keylength + vlength : 10 + keylength + vlength + tagsLength;
            byte[] backingArray = new byte[length];
            int pos = 0;
            pos = Bytes.putInt(backingArray, pos, keylength);
            pos = Bytes.putInt(backingArray, pos, vlength);
            int elemLen = this.readIntoArray(backingArray, pos + 2, this.compression.getDictionary(CompressionContext.DictionaryIndex.ROW));
            CompressedKvDecoder.checkLength(elemLen, Short.MAX_VALUE);
            pos = Bytes.putShort(backingArray, pos, (short)elemLen);
            pos += elemLen;
            elemLen = this.readIntoArray(backingArray, pos + 1, this.compression.getDictionary(CompressionContext.DictionaryIndex.FAMILY));
            CompressedKvDecoder.checkLength(elemLen, 127);
            pos = Bytes.putByte(backingArray, pos, (byte)elemLen);
            pos += elemLen;
            elemLen = this.readIntoArray(backingArray, pos, this.compression.getDictionary(CompressionContext.DictionaryIndex.QUALIFIER));
            int tsTypeValLen = length - (pos += elemLen);
            if (tagsLength > 0) {
                tsTypeValLen = tsTypeValLen - tagsLength - 2;
            }
            IOUtils.readFully((InputStream)this.in, (byte[])backingArray, (int)pos, (int)tsTypeValLen);
            pos += tsTypeValLen;
            if (tagsLength > 0) {
                pos = Bytes.putAsShort(backingArray, pos, tagsLength);
                if (this.compression.tagCompressionContext != null) {
                    this.compression.tagCompressionContext.uncompressTags(this.in, backingArray, pos, tagsLength);
                } else {
                    IOUtils.readFully((InputStream)this.in, (byte[])backingArray, (int)pos, (int)tagsLength);
                }
            }
            return new KeyValue(backingArray, 0, length);
        }

        private int readIntoArray(byte[] to, int offset, Dictionary dict) throws IOException {
            byte status = (byte)this.in.read();
            if (status == -1) {
                int length = StreamUtils.readRawVarint32(this.in);
                IOUtils.readFully((InputStream)this.in, (byte[])to, (int)offset, (int)length);
                dict.addEntry(to, offset, length);
                return length;
            }
            short dictIdx = StreamUtils.toShort(status, (byte)this.in.read());
            byte[] entry = dict.getEntry(dictIdx);
            if (entry == null) {
                throw new IOException("Missing dictionary entry for index " + dictIdx);
            }
            Bytes.putBytes(to, offset, entry, 0, entry.length);
            return entry.length;
        }

        private static void checkLength(int len, int max) throws IOException {
            if (len < 0 || len > max) {
                throw new IOException("Invalid length for compresesed portion of keyvalue: " + len);
            }
        }
    }

    static class CompressedKvEncoder
    extends BaseEncoder {
        private final CompressionContext compression;

        public CompressedKvEncoder(OutputStream out, CompressionContext compression) {
            super(out);
            this.compression = compression;
        }

        @Override
        public void write(Cell cell) throws IOException {
            StreamUtils.writeRawVInt32(this.out, KeyValueUtil.keyLength(cell));
            StreamUtils.writeRawVInt32(this.out, cell.getValueLength());
            int tagsLength = cell.getTagsLength();
            StreamUtils.writeRawVInt32(this.out, tagsLength);
            PrivateCellUtil.compressRow(this.out, cell, this.compression.getDictionary(CompressionContext.DictionaryIndex.ROW));
            PrivateCellUtil.compressFamily(this.out, cell, this.compression.getDictionary(CompressionContext.DictionaryIndex.FAMILY));
            PrivateCellUtil.compressQualifier(this.out, cell, this.compression.getDictionary(CompressionContext.DictionaryIndex.QUALIFIER));
            StreamUtils.writeLong(this.out, cell.getTimestamp());
            this.out.write(cell.getTypeByte());
            PrivateCellUtil.writeValue(this.out, cell, cell.getValueLength());
            if (tagsLength > 0) {
                if (this.compression.tagCompressionContext != null) {
                    PrivateCellUtil.compressTags(this.out, cell, this.compression.tagCompressionContext);
                } else {
                    PrivateCellUtil.writeTags(this.out, cell, tagsLength);
                }
            }
        }
    }

    static class NoneUncompressor
    implements ByteStringUncompressor {
        NoneUncompressor() {
        }

        @Override
        public byte[] uncompress(ByteString data2, Enum dictIndex) {
            return data2.toByteArray();
        }
    }

    static class NoneCompressor
    implements ByteStringCompressor {
        NoneCompressor() {
        }

        @Override
        public ByteString compress(byte[] data2, Enum dictIndex) {
            return UnsafeByteOperations.unsafeWrap(data2);
        }
    }

    static class BaosAndCompressor
    extends ByteArrayOutputStream
    implements ByteStringCompressor {
        private CompressionContext compressionContext;

        public BaosAndCompressor(CompressionContext compressionContext) {
            this.compressionContext = compressionContext;
        }

        public ByteString toByteString() {
            return ByteString.copyFrom(this.buf, 0, this.count);
        }

        @Override
        public ByteString compress(byte[] data2, Enum dictIndex) throws IOException {
            this.writeCompressed(data2, dictIndex);
            ByteString result2 = ByteString.copyFrom(this.buf, 0, this.count);
            this.reset();
            return result2;
        }

        private void writeCompressed(byte[] data2, Enum dictIndex) throws IOException {
            Dictionary dict = this.compressionContext.getDictionary(dictIndex);
            assert (dict != null);
            short dictIdx = dict.findEntry(data2, 0, data2.length);
            if (dictIdx == -1) {
                this.write(-1);
                StreamUtils.writeRawVInt32(this, data2.length);
                this.write(data2, 0, data2.length);
            } else {
                StreamUtils.writeShort(this, dictIdx);
            }
        }
    }

    static class StatelessUncompressor
    implements ByteStringUncompressor {
        CompressionContext compressionContext;

        public StatelessUncompressor(CompressionContext compressionContext) {
            this.compressionContext = compressionContext;
        }

        @Override
        public byte[] uncompress(ByteString data2, Enum dictIndex) throws IOException {
            return WALCellCodec.uncompressByteString(data2, this.compressionContext.getDictionary(dictIndex));
        }
    }

    public static interface ByteStringUncompressor {
        public byte[] uncompress(ByteString var1, Enum var2) throws IOException;
    }

    public static interface ByteStringCompressor {
        public ByteString compress(byte[] var1, Enum var2) throws IOException;
    }
}

