/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.rsgroup;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.net.Address;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RSGroupInfo {
    public static final String DEFAULT_GROUP = "default";
    public static final String NAMESPACE_DESC_PROP_GROUP = "hbase.rsgroup.name";
    public static final String TABLE_DESC_PROP_GROUP = "hbase.rsgroup.name";
    private final String name;
    private final SortedSet<Address> servers;
    private final SortedSet<TableName> tables;
    private final Map<String, String> configuration;

    public RSGroupInfo(String name2) {
        this(name2, new TreeSet<Address>(), new TreeSet<TableName>());
    }

    RSGroupInfo(String name2, SortedSet<Address> servers, SortedSet<TableName> tables) {
        this.name = name2;
        this.servers = servers == null ? new TreeSet<Address>() : new TreeSet<Address>(servers);
        this.tables = tables == null ? new TreeSet<TableName>() : new TreeSet<TableName>(tables);
        this.configuration = new HashMap<String, String>();
    }

    public RSGroupInfo(RSGroupInfo src) {
        this(src.name, src.servers, src.tables);
        src.configuration.forEach(this::setConfiguration);
    }

    public String getName() {
        return this.name;
    }

    public void addServer(Address hostPort) {
        this.servers.add(hostPort);
    }

    public void addAllServers(Collection<Address> hostPort) {
        this.servers.addAll(hostPort);
    }

    public boolean containsServer(Address hostPort) {
        return this.servers.contains(hostPort);
    }

    public Set<Address> getServers() {
        return this.servers;
    }

    public boolean removeServer(Address hostPort) {
        return this.servers.remove(hostPort);
    }

    public SortedSet<TableName> getTables() {
        return this.tables;
    }

    public void addTable(TableName table) {
        this.tables.add(table);
    }

    public void addAllTables(Collection<TableName> arg) {
        this.tables.addAll(arg);
    }

    public boolean containsTable(TableName table) {
        return this.tables.contains(table);
    }

    public boolean removeTable(TableName table) {
        return this.tables.remove(table);
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public void setConfiguration(String key, String value) {
        this.configuration.put(key, Objects.requireNonNull(value));
    }

    public void removeConfiguration(String key) {
        this.configuration.remove(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name:");
        sb.append(this.name);
        sb.append(", ");
        sb.append(" Servers:");
        sb.append(this.servers);
        sb.append(", ");
        sb.append(" Tables:");
        sb.append(this.tables);
        sb.append(", ");
        sb.append(" Configurations:");
        sb.append(this.configuration);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RSGroupInfo rsGroupInfo = (RSGroupInfo)o;
        if (!this.name.equals(rsGroupInfo.name)) {
            return false;
        }
        if (!this.servers.equals(rsGroupInfo.servers)) {
            return false;
        }
        if (!this.tables.equals(rsGroupInfo.tables)) {
            return false;
        }
        return this.configuration.equals(rsGroupInfo.configuration);
    }

    public int hashCode() {
        int result2 = this.servers.hashCode();
        result2 = 31 * result2 + this.tables.hashCode();
        result2 = 31 * result2 + this.name.hashCode();
        result2 = 31 * result2 + this.configuration.hashCode();
        return result2;
    }
}

