/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.AuthUtil;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.security.Superusers;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.GlobalPermission;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class AuthManager {
    PermissionCache<NamespacePermission> NS_NO_PERMISSION = new PermissionCache();
    PermissionCache<TablePermission> TBL_NO_PERMISSION = new PermissionCache();
    private Map<String, GlobalPermission> globalCache = new ConcurrentHashMap<String, GlobalPermission>();
    private ConcurrentHashMap<String, PermissionCache<NamespacePermission>> namespaceCache = new ConcurrentHashMap();
    private ConcurrentHashMap<TableName, PermissionCache<TablePermission>> tableCache = new ConcurrentHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(AuthManager.class);
    private Configuration conf;
    private final AtomicLong mtime = new AtomicLong(0L);

    AuthManager(Configuration conf) {
        this.conf = conf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshTableCacheFromWritable(TableName table, byte[] data2) throws IOException {
        if (data2 != null && data2.length > 0) {
            try {
                ListMultimap<String, Permission> perms = PermissionStorage.readPermissions(data2, this.conf);
                if (perms == null) return;
                if (Bytes.equals(table.getName(), PermissionStorage.ACL_GLOBAL_NAME)) {
                    this.updateGlobalCache(perms);
                    return;
                }
                this.updateTableCache(table, perms);
                return;
            }
            catch (DeserializationException e) {
                throw new IOException(e);
            }
        } else {
            LOG.info("Skipping permission cache refresh because writable data is empty");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshNamespaceCacheFromWritable(String namespace, byte[] data2) throws IOException {
        if (data2 != null && data2.length > 0) {
            try {
                ListMultimap<String, Permission> perms = PermissionStorage.readPermissions(data2, this.conf);
                if (perms == null) return;
                this.updateNamespaceCache(namespace, perms);
                return;
            }
            catch (DeserializationException e) {
                throw new IOException(e);
            }
        } else {
            LOG.debug("Skipping permission cache refresh because writable data is empty");
        }
    }

    private void updateGlobalCache(ListMultimap<String, Permission> globalPerms) {
        this.globalCache.clear();
        for (String name2 : globalPerms.keySet()) {
            for (Permission permission : globalPerms.get((Object)name2)) {
                if (permission instanceof TablePermission) {
                    this.globalCache.put(name2, new GlobalPermission(permission.getActions()));
                    continue;
                }
                this.globalCache.put(name2, (GlobalPermission)permission);
            }
        }
        this.mtime.incrementAndGet();
    }

    private void updateTableCache(TableName table, ListMultimap<String, Permission> tablePerms) {
        PermissionCache cacheToUpdate = this.tableCache.getOrDefault(table, new PermissionCache());
        this.clearCache(cacheToUpdate);
        this.updateCache(tablePerms, cacheToUpdate);
        this.tableCache.put(table, cacheToUpdate);
        this.mtime.incrementAndGet();
    }

    private void updateNamespaceCache(String namespace, ListMultimap<String, Permission> nsPerms) {
        PermissionCache cacheToUpdate = this.namespaceCache.getOrDefault(namespace, new PermissionCache());
        this.clearCache(cacheToUpdate);
        this.updateCache(nsPerms, cacheToUpdate);
        this.namespaceCache.put(namespace, cacheToUpdate);
        this.mtime.incrementAndGet();
    }

    private void clearCache(PermissionCache cacheToUpdate) {
        cacheToUpdate.clear();
    }

    private void updateCache(ListMultimap<String, ? extends Permission> newPermissions, PermissionCache cacheToUpdate) {
        for (String name2 : newPermissions.keySet()) {
            for (Permission permission : newPermissions.get((Object)name2)) {
                cacheToUpdate.put(name2, permission);
            }
        }
    }

    public boolean authorizeUserGlobal(User user, Permission.Action action) {
        if (user == null) {
            return false;
        }
        if (Superusers.isSuperUser(user)) {
            return true;
        }
        if (this.authorizeGlobal(this.globalCache.get(user.getShortName()), action)) {
            return true;
        }
        for (String group : user.getGroupNames()) {
            if (!this.authorizeGlobal(this.globalCache.get(AuthUtil.toGroupEntry(group)), action)) continue;
            return true;
        }
        return false;
    }

    private boolean authorizeGlobal(GlobalPermission permissions, Permission.Action action) {
        return permissions != null && permissions.implies(action);
    }

    public boolean authorizeUserNamespace(User user, String namespace, Permission.Action action) {
        if (user == null) {
            return false;
        }
        if (this.authorizeUserGlobal(user, action)) {
            return true;
        }
        PermissionCache<NamespacePermission> nsPermissions = this.namespaceCache.getOrDefault(namespace, this.NS_NO_PERMISSION);
        if (this.authorizeNamespace(nsPermissions.get(user.getShortName()), namespace, action)) {
            return true;
        }
        for (String group : user.getGroupNames()) {
            if (!this.authorizeNamespace(nsPermissions.get(AuthUtil.toGroupEntry(group)), namespace, action)) continue;
            return true;
        }
        return false;
    }

    private boolean authorizeNamespace(Set<NamespacePermission> permissions, String namespace, Permission.Action action) {
        if (permissions == null) {
            return false;
        }
        for (NamespacePermission permission : permissions) {
            if (!permission.implies(namespace, action)) continue;
            return true;
        }
        return false;
    }

    public boolean accessUserTable(User user, TableName table, Permission.Action action) {
        if (user == null) {
            return false;
        }
        if (table == null) {
            table = PermissionStorage.ACL_TABLE_NAME;
        }
        if (this.authorizeUserNamespace(user, table.getNamespaceAsString(), action)) {
            return true;
        }
        PermissionCache<TablePermission> tblPermissions = this.tableCache.getOrDefault(table, this.TBL_NO_PERMISSION);
        if (this.hasAccessTable(tblPermissions.get(user.getShortName()), action)) {
            return true;
        }
        for (String group : user.getGroupNames()) {
            if (!this.hasAccessTable(tblPermissions.get(AuthUtil.toGroupEntry(group)), action)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAccessTable(Set<TablePermission> permissions, Permission.Action action) {
        if (permissions == null) {
            return false;
        }
        for (TablePermission permission : permissions) {
            if (!permission.implies(action)) continue;
            return true;
        }
        return false;
    }

    public boolean authorizeUserTable(User user, TableName table, Permission.Action action) {
        return this.authorizeUserTable(user, table, null, null, action);
    }

    public boolean authorizeUserTable(User user, TableName table, byte[] family, Permission.Action action) {
        return this.authorizeUserTable(user, table, family, null, action);
    }

    public boolean authorizeUserTable(User user, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (user == null) {
            return false;
        }
        if (table == null) {
            table = PermissionStorage.ACL_TABLE_NAME;
        }
        if (this.authorizeUserNamespace(user, table.getNamespaceAsString(), action)) {
            return true;
        }
        PermissionCache<TablePermission> tblPermissions = this.tableCache.getOrDefault(table, this.TBL_NO_PERMISSION);
        if (this.authorizeTable(tblPermissions.get(user.getShortName()), table, family, qualifier, action)) {
            return true;
        }
        for (String group : user.getGroupNames()) {
            if (!this.authorizeTable(tblPermissions.get(AuthUtil.toGroupEntry(group)), table, family, qualifier, action)) continue;
            return true;
        }
        return false;
    }

    private boolean authorizeTable(Set<TablePermission> permissions, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (permissions == null) {
            return false;
        }
        for (TablePermission permission : permissions) {
            if (!permission.implies(table, family, qualifier, action)) continue;
            return true;
        }
        return false;
    }

    public boolean authorizeUserFamily(User user, TableName table, byte[] family, Permission.Action action) {
        PermissionCache<TablePermission> tblPermissions = this.tableCache.getOrDefault(table, this.TBL_NO_PERMISSION);
        if (this.authorizeFamily(tblPermissions.get(user.getShortName()), table, family, action)) {
            return true;
        }
        for (String group : user.getGroupNames()) {
            if (!this.authorizeFamily(tblPermissions.get(AuthUtil.toGroupEntry(group)), table, family, action)) continue;
            return true;
        }
        return false;
    }

    private boolean authorizeFamily(Set<TablePermission> permissions, TableName table, byte[] family, Permission.Action action) {
        if (permissions == null) {
            return false;
        }
        for (TablePermission permission : permissions) {
            if (!permission.implies(table, family, action)) continue;
            return true;
        }
        return false;
    }

    public boolean authorizeCell(User user, TableName table, Cell cell, Permission.Action action) {
        try {
            List<Permission> perms = PermissionStorage.getCellPermissionsForUser(user, cell);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Perms for user {} in table {} in cell {}: {}", new Object[]{user.getShortName(), table, cell, perms != null ? perms : ""});
            }
            if (perms != null) {
                for (Permission p : perms) {
                    if (!p.implies(action)) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed parse of ACL tag in cell " + cell);
        }
        return false;
    }

    public void removeNamespace(byte[] ns) {
        this.namespaceCache.remove(Bytes.toString(ns));
    }

    public void removeTable(TableName table) {
        this.tableCache.remove(table);
    }

    public long getMTime() {
        return this.mtime.get();
    }

    private static class PermissionCache<T extends Permission> {
        private final Object mutex = new Object();
        private Map<String, Set<T>> cache = new HashMap<String, Set<T>>();

        private PermissionCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(String name2, T perm) {
            Object object = this.mutex;
            synchronized (object) {
                Set perms = this.cache.getOrDefault(name2, new HashSet());
                perms.add(perm);
                this.cache.put(name2, perms);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<T> get(String name2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.get(name2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            Object object = this.mutex;
            synchronized (object) {
                for (Map.Entry<String, Set<T>> entry : this.cache.entrySet()) {
                    entry.getValue().clear();
                }
                this.cache.clear();
            }
        }
    }
}

