/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.com.google.protobuf.RpcController;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hudi.org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.SingleResponse;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MapReduceProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ResponseConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseConverter.class);

    private ResponseConverter() {
    }

    public static SingleResponse getResult(ClientProtos.MutateRequest request, ClientProtos.MutateResponse response, CellScanner cells) throws IOException {
        SingleResponse singleResponse = new SingleResponse();
        SingleResponse.Entry entry = new SingleResponse.Entry();
        entry.setResult(ProtobufUtil.toResult(response.getResult(), cells));
        entry.setProcessed(response.getProcessed());
        singleResponse.setEntry(entry);
        return singleResponse;
    }

    public static MultiResponse getResults(ClientProtos.MultiRequest request, ClientProtos.MultiResponse response, CellScanner cells) throws IOException {
        return ResponseConverter.getResults(request, null, response, cells);
    }

    public static MultiResponse getResults(ClientProtos.MultiRequest request, Map<Integer, Integer> indexMap, ClientProtos.MultiResponse response, CellScanner cells) throws IOException {
        int responseRegionActionResultCount;
        int requestRegionActionCount = request.getRegionActionCount();
        if (requestRegionActionCount != (responseRegionActionResultCount = response.getRegionActionResultCount())) {
            throw new IllegalStateException("Request mutation count=" + requestRegionActionCount + " does not match response mutation result count=" + responseRegionActionResultCount);
        }
        MultiResponse results = new MultiResponse();
        for (int i = 0; i < responseRegionActionResultCount; ++i) {
            Result r;
            Result result2;
            Integer index;
            ClientProtos.RegionAction actions = request.getRegionAction(i);
            ClientProtos.RegionActionResult actionResult = response.getRegionActionResult(i);
            HBaseProtos.RegionSpecifier rs = actions.getRegion();
            if (rs.hasType() && rs.getType() != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                throw new IllegalArgumentException("We support only encoded types for protobuf multi response.");
            }
            byte[] regionName = rs.getValue().toByteArray();
            if (actionResult.hasException()) {
                Throwable regionException = ProtobufUtil.toException(actionResult.getException());
                results.addException(regionName, regionException);
                continue;
            }
            if (actions.getActionCount() != actionResult.getResultOrExceptionCount()) {
                throw new IllegalStateException("actions.getActionCount=" + actions.getActionCount() + ", actionResult.getResultOrExceptionCount=" + actionResult.getResultOrExceptionCount() + " for region " + actions.getRegion());
            }
            Integer n = index = indexMap == null ? null : indexMap.get(i);
            if (index != null) {
                if (actions.hasCondition()) {
                    results.add(regionName, index, ResponseConverter.getCheckAndMutateResult(actionResult, cells));
                    continue;
                }
                results.add(regionName, index, ResponseConverter.getMutateRowResult(actionResult, cells));
                continue;
            }
            if (actions.hasCondition()) {
                for (ClientProtos.ResultOrException roe : actionResult.getResultOrExceptionList()) {
                    result2 = null;
                    r = ProtobufUtil.toResult(roe.getResult(), cells);
                    if (!r.isEmpty()) {
                        result2 = r;
                    }
                    results.add(regionName, roe.getIndex(), new CheckAndMutateResult(actionResult.getProcessed(), result2));
                }
                continue;
            }
            if (actionResult.hasProcessed()) {
                for (ClientProtos.ResultOrException roe : actionResult.getResultOrExceptionList()) {
                    result2 = actionResult.getProcessed() ? ProtobufUtil.EMPTY_RESULT_EXISTS_TRUE : ProtobufUtil.EMPTY_RESULT_EXISTS_FALSE;
                    r = ProtobufUtil.toResult(roe.getResult(), cells);
                    if (!r.isEmpty()) {
                        r.setExists(true);
                        result2 = r;
                    }
                    results.add(regionName, roe.getIndex(), result2);
                }
                continue;
            }
            for (ClientProtos.ResultOrException roe : actionResult.getResultOrExceptionList()) {
                Object responseValue = roe.hasException() ? ProtobufUtil.toException(roe.getException()) : (roe.hasResult() ? ProtobufUtil.toResult(roe.getResult(), cells) : (roe.hasServiceResult() ? roe.getServiceResult() : ProtobufUtil.EMPTY_RESULT_EXISTS_TRUE));
                results.add(regionName, roe.getIndex(), responseValue);
            }
        }
        if (response.hasRegionStatistics()) {
            ClientProtos.MultiRegionLoadStats stats = response.getRegionStatistics();
            for (int i = 0; i < stats.getRegionCount(); ++i) {
                results.addStatistic(stats.getRegion(i).getValue().toByteArray(), stats.getStat(i));
            }
        }
        return results;
    }

    private static CheckAndMutateResult getCheckAndMutateResult(ClientProtos.RegionActionResult actionResult, CellScanner cells) throws IOException {
        Result r;
        ClientProtos.ResultOrException roe;
        Result result2 = null;
        if (actionResult.getResultOrExceptionCount() > 0 && (roe = actionResult.getResultOrException(0)).hasResult() && !(r = ProtobufUtil.toResult(roe.getResult(), cells)).isEmpty()) {
            result2 = r;
        }
        return new CheckAndMutateResult(actionResult.getProcessed(), result2);
    }

    private static Result getMutateRowResult(ClientProtos.RegionActionResult actionResult, CellScanner cells) throws IOException {
        if (actionResult.getProcessed()) {
            ClientProtos.ResultOrException roe;
            Result r;
            Result result2 = null;
            if (actionResult.getResultOrExceptionCount() > 0 && !(r = ProtobufUtil.toResult((roe = actionResult.getResultOrException(0)).getResult(), cells)).isEmpty()) {
                r.setExists(true);
                result2 = r;
            }
            if (result2 != null) {
                return result2;
            }
            return ProtobufUtil.EMPTY_RESULT_EXISTS_TRUE;
        }
        return ProtobufUtil.EMPTY_RESULT_EXISTS_FALSE;
    }

    public static CheckAndMutateResult getCheckAndMutateResult(ClientProtos.MutateResponse mutateResponse, CellScanner cells) throws IOException {
        boolean success = mutateResponse.getProcessed();
        Result result2 = null;
        if (mutateResponse.hasResult()) {
            result2 = ProtobufUtil.toResult(mutateResponse.getResult(), cells);
        }
        return new CheckAndMutateResult(success, result2);
    }

    public static ClientProtos.ResultOrException.Builder buildActionResult(Throwable t) {
        ClientProtos.ResultOrException.Builder builder = ClientProtos.ResultOrException.newBuilder();
        if (t != null) {
            builder.setException(ResponseConverter.buildException(t));
        }
        return builder;
    }

    public static ClientProtos.ResultOrException.Builder buildActionResult(ClientProtos.Result r) {
        ClientProtos.ResultOrException.Builder builder = ClientProtos.ResultOrException.newBuilder();
        if (r != null) {
            builder.setResult(r);
        }
        return builder;
    }

    public static HBaseProtos.NameBytesPair buildException(Throwable t) {
        HBaseProtos.NameBytesPair.Builder parameterBuilder = HBaseProtos.NameBytesPair.newBuilder();
        parameterBuilder.setName(t.getClass().getName());
        parameterBuilder.setValue(ByteString.copyFromUtf8(StringUtils.stringifyException((Throwable)t)));
        return parameterBuilder.build();
    }

    public static AccessControlProtos.HasPermissionResponse buildHasPermissionResponse(boolean hasPermission) {
        AccessControlProtos.HasPermissionResponse.Builder builder = AccessControlProtos.HasPermissionResponse.newBuilder();
        builder.setHasPermission(hasPermission);
        return builder.build();
    }

    public static List<RegionInfo> getRegionInfos(AdminProtos.GetOnlineRegionResponse proto) {
        if (proto == null || proto.getRegionInfoCount() == 0) {
            return null;
        }
        return ProtobufUtil.getRegionInfos(proto);
    }

    public static boolean isClosed(AdminProtos.CloseRegionResponse proto) {
        if (proto == null || !proto.hasClosed()) {
            return false;
        }
        return proto.getClosed();
    }

    public static AdminProtos.GetServerInfoResponse buildGetServerInfoResponse(ServerName serverName, int webuiPort) {
        AdminProtos.GetServerInfoResponse.Builder builder = AdminProtos.GetServerInfoResponse.newBuilder();
        AdminProtos.ServerInfo.Builder serverInfoBuilder = AdminProtos.ServerInfo.newBuilder();
        serverInfoBuilder.setServerName(ProtobufUtil.toServerName(serverName));
        if (webuiPort >= 0) {
            serverInfoBuilder.setWebuiPort(webuiPort);
        }
        builder.setServerInfo(serverInfoBuilder.build());
        return builder.build();
    }

    public static AdminProtos.GetOnlineRegionResponse buildGetOnlineRegionResponse(List<RegionInfo> regions) {
        AdminProtos.GetOnlineRegionResponse.Builder builder = AdminProtos.GetOnlineRegionResponse.newBuilder();
        for (RegionInfo region : regions) {
            builder.addRegionInfo(ProtobufUtil.toRegionInfo(region));
        }
        return builder.build();
    }

    public static MasterProtos.RunCatalogScanResponse buildRunCatalogScanResponse(int numCleaned) {
        return MasterProtos.RunCatalogScanResponse.newBuilder().setScanResult(numCleaned).build();
    }

    public static MasterProtos.EnableCatalogJanitorResponse buildEnableCatalogJanitorResponse(boolean prevValue) {
        return MasterProtos.EnableCatalogJanitorResponse.newBuilder().setPrevValue(prevValue).build();
    }

    public static MasterProtos.RunCleanerChoreResponse buildRunCleanerChoreResponse(boolean ran) {
        return MasterProtos.RunCleanerChoreResponse.newBuilder().setCleanerChoreRan(ran).build();
    }

    public static RegionServerStatusProtos.GetLastFlushedSequenceIdResponse buildGetLastFlushedSequenceIdResponse(ClusterStatusProtos.RegionStoreSequenceIds ids) {
        return RegionServerStatusProtos.GetLastFlushedSequenceIdResponse.newBuilder().setLastFlushedSequenceId(ids.getLastFlushedSequenceId()).addAllStoreLastFlushedSequenceId(ids.getStoreSequenceIdList()).build();
    }

    public static void setControllerException(RpcController controller, IOException ioe) {
        if (controller != null) {
            if (controller instanceof ServerRpcController) {
                ((ServerRpcController)controller).setFailedOn(ioe);
            } else {
                controller.setFailed(StringUtils.stringifyException((Throwable)ioe));
            }
        }
    }

    @Nullable
    public static IOException getControllerException(org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.RpcController controller) throws IOException {
        if (controller != null && controller.failed()) {
            if (controller instanceof ServerRpcController) {
                return ((ServerRpcController)((Object)controller)).getFailedOn();
            }
            return new DoNotRetryIOException(controller.errorText());
        }
        return null;
    }

    public static Result[] getResults(CellScanner cellScanner, ClientProtos.ScanResponse response) throws IOException {
        if (response == null) {
            return null;
        }
        int noOfResults = cellScanner != null ? response.getCellsPerResultCount() : response.getResultsCount();
        Result[] results = new Result[noOfResults];
        for (int i = 0; i < noOfResults; ++i) {
            if (cellScanner != null) {
                int noOfCells = response.getCellsPerResult(i);
                boolean isPartial = response.getPartialFlagPerResultCount() > i ? response.getPartialFlagPerResult(i) : false;
                ArrayList<Cell> cells = new ArrayList<Cell>(noOfCells);
                for (int j = 0; j < noOfCells; ++j) {
                    try {
                        if (!cellScanner.advance()) {
                            String msg = "Results sent from server=" + noOfResults + ". But only got " + i + " results completely at client. Resetting the scanner to scan again.";
                            LOG.error(msg);
                            throw new DoNotRetryIOException(msg);
                        }
                    }
                    catch (IOException ioe) {
                        LOG.error("Exception while reading cells from result.Resetting the scanner to scan again.", (Throwable)ioe);
                        throw new DoNotRetryIOException("Resetting the scanner.", ioe);
                    }
                    cells.add(cellScanner.current());
                }
                results[i] = Result.create(cells, null, response.getStale(), isPartial);
                continue;
            }
            results[i] = ProtobufUtil.toResult(response.getResults(i));
        }
        return results;
    }

    public static Map<String, Long> getScanMetrics(ClientProtos.ScanResponse response) {
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        if (response == null || !response.hasScanMetrics()) {
            return metricMap;
        }
        MapReduceProtos.ScanMetrics metrics = response.getScanMetrics();
        int numberOfMetrics = metrics.getMetricsCount();
        for (int i = 0; i < numberOfMetrics; ++i) {
            HBaseProtos.NameInt64Pair metricPair = metrics.getMetrics(i);
            if (metricPair == null) continue;
            String name2 = metricPair.getName();
            Long value = metricPair.getValue();
            if (name2 == null || value == null) continue;
            metricMap.put(name2, value);
        }
        return metricMap;
    }

    public static AdminProtos.ClearRegionBlockCacheResponse buildClearRegionBlockCacheResponse(HBaseProtos.CacheEvictionStats cacheEvictionStats) {
        return AdminProtos.ClearRegionBlockCacheResponse.newBuilder().setStats(cacheEvictionStats).build();
    }
}

