/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ConcurrentMapUtils {
    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map2, K key, Supplier<V> supplier) {
        return ConcurrentMapUtils.computeIfAbsent(map2, key, supplier, () -> {});
    }

    public static <K, V> V computeIfAbsentEx(ConcurrentMap<K, V> map2, K key, IOExceptionSupplier<V> supplier) throws IOException {
        V newValue;
        Object v = map2.get(key);
        return v == null && (newValue = supplier.get()) != null && (v = map2.putIfAbsent(key, newValue)) == null ? newValue : v;
    }

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map2, K key, Supplier<V> supplier, Runnable actionIfAbsent) {
        Object v = map2.get(key);
        if (v != null) {
            return v;
        }
        V newValue = supplier.get();
        v = map2.putIfAbsent(key, newValue);
        if (v != null) {
            return v;
        }
        actionIfAbsent.run();
        return newValue;
    }

    @FunctionalInterface
    public static interface IOExceptionSupplier<V> {
        public V get() throws IOException;
    }
}

