/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKMetadata {
    private static final byte MAGIC = -1;
    private static final int MAGIC_SIZE = 1;
    private static final int ID_LENGTH_OFFSET = 1;
    private static final int ID_LENGTH_SIZE = 4;

    private ZKMetadata() {
    }

    public static byte[] appendMetaData(byte[] id, byte[] data2) {
        if (data2 == null || data2.length == 0) {
            return data2;
        }
        byte[] salt = Bytes.toBytes(ThreadLocalRandom.current().nextLong());
        int idLength = id.length + salt.length;
        byte[] newData = new byte[5 + idLength + data2.length];
        int pos = 0;
        pos = Bytes.putByte(newData, pos, (byte)-1);
        pos = Bytes.putInt(newData, pos, idLength);
        pos = Bytes.putBytes(newData, pos, id, 0, id.length);
        pos = Bytes.putBytes(newData, pos, salt, 0, salt.length);
        pos = Bytes.putBytes(newData, pos, data2, 0, data2.length);
        return newData;
    }

    public static byte[] removeMetaData(byte[] data2) {
        if (data2 == null || data2.length == 0) {
            return data2;
        }
        byte magic = data2[0];
        if (magic != -1) {
            return data2;
        }
        int idLength = Bytes.toInt(data2, 1);
        int dataLength = data2.length - 1 - 4 - idLength;
        int dataOffset = 5 + idLength;
        byte[] newData = new byte[dataLength];
        System.arraycopy(data2, dataOffset, newData, 0, dataLength);
        return newData;
    }
}

