/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.metrics2.lib;

import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsInfoImpl;
import org.apache.hadoop.metrics2.lib.MutableCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.DefaultMetricsSystemHelper;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MutableSizeHistogram;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MutableTimeHistogram;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DynamicMetricsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicMetricsRegistry.class);
    private final ConcurrentMap<String, MutableMetric> metricsMap = Maps.newConcurrentMap();
    private final ConcurrentMap<String, MetricsTag> tagsMap = Maps.newConcurrentMap();
    private final MetricsInfo metricsInfo;
    private final DefaultMetricsSystemHelper helper = new DefaultMetricsSystemHelper();
    private static final String[] histogramSuffixes = new String[]{"_num_ops", "_min", "_max", "_median", "_75th_percentile", "_90th_percentile", "_95th_percentile", "_99th_percentile"};

    public DynamicMetricsRegistry(String name2) {
        this(Interns.info(name2, name2));
    }

    public DynamicMetricsRegistry(MetricsInfo info) {
        this.metricsInfo = info;
    }

    public MetricsInfo info() {
        return this.metricsInfo;
    }

    public MutableMetric get(String name2) {
        return (MutableMetric)this.metricsMap.get(name2);
    }

    public MetricsTag getTag(String name2) {
        return (MetricsTag)this.tagsMap.get(name2);
    }

    public MutableFastCounter newCounter(String name2, String desc, long iVal) {
        return this.newCounter((MetricsInfo)new MetricsInfoImpl(name2, desc), iVal);
    }

    public MutableFastCounter newCounter(MetricsInfo info, long iVal) {
        MutableFastCounter ret = new MutableFastCounter(info, iVal);
        return this.addNewMetricIfAbsent(info.name(), ret, MutableFastCounter.class);
    }

    public MutableGaugeLong newGauge(String name2, String desc, long iVal) {
        return this.newGauge((MetricsInfo)new MetricsInfoImpl(name2, desc), iVal);
    }

    public MutableGaugeLong newGauge(MetricsInfo info, long iVal) {
        MutableGaugeLong ret = new MutableGaugeLong(info, iVal);
        return this.addNewMetricIfAbsent(info.name(), ret, MutableGaugeLong.class);
    }

    public MutableStat newStat(String name2, String desc, String sampleName, String valueName, boolean extended) {
        MutableStat ret = new MutableStat(name2, desc, sampleName, valueName, extended);
        return this.addNewMetricIfAbsent(name2, ret, MutableStat.class);
    }

    public MutableStat newStat(String name2, String desc, String sampleName, String valueName) {
        return this.newStat(name2, desc, sampleName, valueName, false);
    }

    public MutableRate newRate(String name2) {
        return this.newRate(name2, name2, false);
    }

    public MutableRate newRate(String name2, String description2) {
        return this.newRate(name2, description2, false);
    }

    public MutableRate newRate(String name2, String desc, boolean extended) {
        return this.newRate(name2, desc, extended, true);
    }

    @InterfaceAudience.Private
    public MutableRate newRate(String name2, String desc, boolean extended, boolean returnExisting) {
        MutableMetric rate;
        if (returnExisting && (rate = (MutableMetric)this.metricsMap.get(name2)) != null) {
            if (rate instanceof MutableRate) {
                return (MutableRate)rate;
            }
            throw new MetricsException("Unexpected metrics type " + rate.getClass() + " for " + name2);
        }
        MutableRate ret = new MutableRate(name2, desc, extended);
        return this.addNewMetricIfAbsent(name2, ret, MutableRate.class);
    }

    public MutableHistogram newHistogram(String name2) {
        return this.newHistogram(name2, "");
    }

    public MutableHistogram newHistogram(String name2, String desc) {
        MutableHistogram histo = new MutableHistogram(name2, desc);
        return this.addNewMetricIfAbsent(name2, histo, MutableHistogram.class);
    }

    public MutableTimeHistogram newTimeHistogram(String name2) {
        return this.newTimeHistogram(name2, "");
    }

    public MutableTimeHistogram newTimeHistogram(String name2, String desc) {
        MutableTimeHistogram histo = new MutableTimeHistogram(name2, desc);
        return this.addNewMetricIfAbsent(name2, histo, MutableTimeHistogram.class);
    }

    public MutableSizeHistogram newSizeHistogram(String name2) {
        return this.newSizeHistogram(name2, "");
    }

    public MutableSizeHistogram newSizeHistogram(String name2, String desc) {
        MutableSizeHistogram histo = new MutableSizeHistogram(name2, desc);
        return this.addNewMetricIfAbsent(name2, histo, MutableSizeHistogram.class);
    }

    synchronized void add(String name2, MutableMetric metric) {
        this.addNewMetricIfAbsent(name2, metric, MutableMetric.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(String name2, long value) {
        MutableMetric m = (MutableMetric)this.metricsMap.get(name2);
        if (m != null) {
            if (!(m instanceof MutableStat)) throw new MetricsException("Unsupported add(value) for metric " + name2);
            ((MutableStat)m).add(value);
            return;
        } else {
            this.metricsMap.put(name2, (MutableMetric)this.newRate(name2));
            this.add(name2, value);
        }
    }

    public DynamicMetricsRegistry setContext(String name2) {
        return this.tag((MetricsInfo)MsInfo.Context, name2, true);
    }

    public DynamicMetricsRegistry tag(String name2, String description2, String value) {
        return this.tag(name2, description2, value, false);
    }

    public DynamicMetricsRegistry tag(String name2, String description2, String value, boolean override) {
        return this.tag((MetricsInfo)new MetricsInfoImpl(name2, description2), value, override);
    }

    public DynamicMetricsRegistry tag(MetricsInfo info, String value, boolean override) {
        MetricsTag tag = Interns.tag(info, value);
        if (!override) {
            MetricsTag existing = this.tagsMap.putIfAbsent(info.name(), tag);
            if (existing != null) {
                throw new MetricsException("Tag " + info.name() + " already exists!");
            }
            return this;
        }
        this.tagsMap.put(info.name(), tag);
        return this;
    }

    public DynamicMetricsRegistry tag(MetricsInfo info, String value) {
        return this.tag(info, value, false);
    }

    Collection<MetricsTag> tags() {
        return this.tagsMap.values();
    }

    Collection<MutableMetric> metrics() {
        return this.metricsMap.values();
    }

    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        for (MetricsTag tag : this.tags()) {
            builder.add(tag);
        }
        for (MutableMetric metric : this.metrics()) {
            metric.snapshot(builder, all);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("info", this.metricsInfo).add("tags", this.tags()).add("metrics", this.metrics()).toString();
    }

    public void removeMetric(String name2) {
        this.helper.removeObjectName(name2);
        this.metricsMap.remove(name2);
    }

    public void removeHistogramMetrics(String baseName) {
        for (String suffix : histogramSuffixes) {
            this.removeMetric(baseName + suffix);
        }
    }

    public MutableGaugeLong getGauge(String gaugeName, long potentialStartingValue) {
        MutableGaugeLong newGauge;
        MutableMetric metric = (MutableMetric)this.metricsMap.get(gaugeName);
        if (metric == null && (metric = this.metricsMap.putIfAbsent(gaugeName, (MutableMetric)(newGauge = new MutableGaugeLong((MetricsInfo)new MetricsInfoImpl(gaugeName, ""), potentialStartingValue)))) == null) {
            return newGauge;
        }
        if (!(metric instanceof MutableGaugeLong)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + gaugeName + " and not of type MetricMutableGaugeLong");
        }
        return (MutableGaugeLong)metric;
    }

    public MutableGaugeInt getGaugeInt(String gaugeName, int potentialStartingValue) {
        MutableGaugeInt newGauge;
        MutableMetric metric = (MutableMetric)this.metricsMap.get(gaugeName);
        if (metric == null && (metric = this.metricsMap.putIfAbsent(gaugeName, (MutableMetric)(newGauge = new MutableGaugeInt((MetricsInfo)new MetricsInfoImpl(gaugeName, ""), potentialStartingValue)))) == null) {
            return newGauge;
        }
        if (!(metric instanceof MutableGaugeInt)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + gaugeName + " and not of type MetricMutableGaugeInr");
        }
        return (MutableGaugeInt)metric;
    }

    public MutableFastCounter getCounter(String counterName, long potentialStartingValue) {
        MutableFastCounter newCounter;
        MutableMetric counter = (MutableMetric)this.metricsMap.get(counterName);
        if (counter == null && (counter = this.metricsMap.putIfAbsent(counterName, (MutableMetric)(newCounter = new MutableFastCounter((MetricsInfo)new MetricsInfoImpl(counterName, ""), potentialStartingValue)))) == null) {
            return newCounter;
        }
        if (!(counter instanceof MutableCounter)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + counterName + " and not of type MutableCounter");
        }
        return (MutableFastCounter)counter;
    }

    public MutableHistogram getHistogram(String histoName) {
        MutableHistogram newCounter;
        MutableMetric histo = (MutableMetric)this.metricsMap.get(histoName);
        if (histo == null && (histo = this.metricsMap.putIfAbsent(histoName, newCounter = new MutableHistogram((MetricsInfo)new MetricsInfoImpl(histoName, "")))) == null) {
            return newCounter;
        }
        if (!(histo instanceof MutableHistogram)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + histoName + " and not of type MutableHistogram");
        }
        return (MutableHistogram)histo;
    }

    private <T extends MutableMetric> T addNewMetricIfAbsent(String name2, T ret, Class<T> metricClass) {
        MutableMetric metric = this.metricsMap.putIfAbsent(name2, ret);
        if (metric == null) {
            return ret;
        }
        return (T)((MutableMetric)this.returnExistingWithCast(metric, metricClass, name2));
    }

    private <T> T returnExistingWithCast(MutableMetric metric, Class<T> metricClass, String name2) {
        if (!metricClass.isAssignableFrom(metric.getClass())) {
            throw new MetricsException("Metric already exists in registry for metric name: " + name2 + " and not of type " + metricClass + " but instead of type " + metric.getClass());
        }
        return (T)metric;
    }

    public void clearMetrics() {
        for (String name2 : this.metricsMap.keySet()) {
            this.helper.removeObjectName(name2);
        }
        this.metricsMap.clear();
    }
}

