/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.dns;

import java.net.IDN;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsMessageUtil;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsRecord;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsRecordType;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;

public abstract class AbstractDnsRecord
implements DnsRecord {
    private final String name;
    private final DnsRecordType type;
    private final short dnsClass;
    private final long timeToLive;
    private int hashCode;

    protected AbstractDnsRecord(String name2, DnsRecordType type2, long timeToLive) {
        this(name2, type2, 1, timeToLive);
    }

    protected AbstractDnsRecord(String name2, DnsRecordType type2, int dnsClass, long timeToLive) {
        ObjectUtil.checkPositiveOrZero(timeToLive, "timeToLive");
        this.name = AbstractDnsRecord.appendTrailingDot(AbstractDnsRecord.IDNtoASCII(name2));
        this.type = ObjectUtil.checkNotNull(type2, "type");
        this.dnsClass = (short)dnsClass;
        this.timeToLive = timeToLive;
    }

    private static String IDNtoASCII(String name2) {
        ObjectUtil.checkNotNull(name2, "name");
        if (PlatformDependent.isAndroid() && ".".equals(name2)) {
            return name2;
        }
        return IDN.toASCII(name2);
    }

    private static String appendTrailingDot(String name2) {
        if (name2.length() > 0 && name2.charAt(name2.length() - 1) != '.') {
            return name2 + '.';
        }
        return name2;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DnsRecordType type() {
        return this.type;
    }

    @Override
    public int dnsClass() {
        return this.dnsClass & 0xFFFF;
    }

    @Override
    public long timeToLive() {
        return this.timeToLive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DnsRecord)) {
            return false;
        }
        DnsRecord that = (DnsRecord)obj;
        int hashCode2 = this.hashCode;
        if (hashCode2 != 0 && hashCode2 != that.hashCode()) {
            return false;
        }
        return this.type().intValue() == that.type().intValue() && this.dnsClass() == that.dnsClass() && this.name().equals(that.name());
    }

    public int hashCode() {
        int hashCode2 = this.hashCode;
        if (hashCode2 != 0) {
            return hashCode2;
        }
        this.hashCode = this.name.hashCode() * 31 + this.type().intValue() * 31 + this.dnsClass();
        return this.hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(StringUtil.simpleClassName(this)).append('(').append(this.name()).append(' ').append(this.timeToLive()).append(' ');
        DnsMessageUtil.appendRecordClass(buf, this.dnsClass()).append(' ').append(this.type().name()).append(')');
        return buf.toString();
    }
}

