/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.io;

import java.io.Writer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.util.BufferRecycler;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.util.TextBuffer;

public final class SegmentedStringWriter
extends Writer {
    protected final TextBuffer _buffer;

    public SegmentedStringWriter(BufferRecycler br) {
        this._buffer = new TextBuffer(br);
    }

    @Override
    public Writer append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence csq) {
        String str = csq.toString();
        this._buffer.append(str, 0, str.length());
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start2, int end) {
        String str = csq.subSequence(start2, end).toString();
        this._buffer.append(str, 0, str.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cbuf) {
        this._buffer.append(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this._buffer.append(cbuf, off, len);
    }

    @Override
    public void write(int c) {
        this._buffer.append((char)c);
    }

    @Override
    public void write(String str) {
        this._buffer.append(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) {
        this._buffer.append(str, off, len);
    }

    public String getAndClear() {
        String result2 = this._buffer.contentsAsString();
        this._buffer.releaseBuffers();
        return result2;
    }
}

