/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonToken;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.io.NumberInput;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.ClassUtil;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.Converter;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> vc) {
        this._valueClass = vc;
    }

    protected StdDeserializer(JavaType valueType) {
        this._valueClass = valueType == null ? null : valueType.getRawClass();
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> deserializer) {
        return ClassUtil.isJacksonStdImpl(deserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeser) {
        return ClassUtil.isJacksonStdImpl(keyDeser);
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (t == JsonToken.VALUE_NULL) {
            return false;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            if (jp.getNumberType() == JsonParser.NumberType.INT) {
                return jp.getIntValue() != 0;
            }
            return this._parseBooleanFromNumber(jp, ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            if ("true".equals(text2) || "True".equals(text2)) {
                return true;
            }
            if ("false".equals(text2) || "False".equals(text2) || text2.length() == 0) {
                return false;
            }
            if (this._hasTextualNull(text2)) {
                return false;
            }
            throw ctxt.weirdStringException(text2, this._valueClass, "only \"true\" or \"false\" recognized");
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            boolean parsed = this._parseBooleanPrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'boolean' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Boolean _parseBoolean(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            if (jp.getNumberType() == JsonParser.NumberType.INT) {
                return jp.getIntValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            return this._parseBooleanFromNumber(jp, ctxt);
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            if ("true".equals(text2) || "True".equals(text2)) {
                return Boolean.TRUE;
            }
            if ("false".equals(text2) || "False".equals(text2)) {
                return Boolean.FALSE;
            }
            if (text2.length() == 0) {
                return (Boolean)this.getEmptyValue();
            }
            if (this._hasTextualNull(text2)) {
                return (Boolean)this.getNullValue();
            }
            throw ctxt.weirdStringException(text2, this._valueClass, "only \"true\" or \"false\" recognized");
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Boolean parsed = this._parseBoolean(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Boolean' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final boolean _parseBooleanFromNumber(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getNumberType() == JsonParser.NumberType.LONG) {
            return jp.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        String str = jp.getText();
        if ("0.0".equals(str) || "0".equals(str)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Byte _parseByte(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getByteValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text2 = jp.getText().trim();
            if (this._hasTextualNull(text2)) {
                return (Byte)this.getNullValue();
            }
            try {
                int len = text2.length();
                if (len == 0) {
                    return (Byte)this.getEmptyValue();
                }
                value = NumberInput.parseInt(text2);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid Byte value");
            }
            if (value < -128 || value > 255) {
                throw ctxt.weirdStringException(text2, this._valueClass, "overflow, value can not be represented as 8-bit value");
            }
            return (byte)value;
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Byte)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Byte parsed = this._parseByte(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Byte' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected Short _parseShort(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getShortValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text2 = jp.getText().trim();
            try {
                int len = text2.length();
                if (len == 0) {
                    return (Short)this.getEmptyValue();
                }
                if (this._hasTextualNull(text2)) {
                    return (Short)this.getNullValue();
                }
                value = NumberInput.parseInt(text2);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid Short value");
            }
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw ctxt.weirdStringException(text2, this._valueClass, "overflow, value can not be represented as 16-bit value");
            }
            return (short)value;
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Short)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Short parsed = this._parseShort(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Short' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final short _parseShortPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        int value = this._parseIntPrimitive(jp, ctxt);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw ctxt.weirdStringException(String.valueOf(value), this._valueClass, "overflow, value can not be represented as 16-bit value");
        }
        return (short)value;
    }

    protected final int _parseIntPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getIntValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            if (this._hasTextualNull(text2)) {
                return 0;
            }
            try {
                int len = text2.length();
                if (len > 9) {
                    long l = Long.parseLong(text2);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ctxt.weirdStringException(text2, this._valueClass, "Overflow: numeric value (" + text2 + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return 0;
                }
                return NumberInput.parseInt(text2);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid int value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            int parsed = this._parseIntPrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'int' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Integer _parseInteger(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getIntValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            try {
                int len = text2.length();
                if (this._hasTextualNull(text2)) {
                    return (Integer)this.getNullValue();
                }
                if (len > 9) {
                    long l = Long.parseLong(text2);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ctxt.weirdStringException(text2, this._valueClass, "Overflow: numeric value (" + text2 + ") out of range of Integer (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return (Integer)this.getEmptyValue();
                }
                return NumberInput.parseInt(text2);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid Integer value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Integer)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Integer parsed = this._parseInteger(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Integer' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Long _parseLong(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getLongValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            if (text2.length() == 0) {
                return (Long)this.getEmptyValue();
            }
            if (this._hasTextualNull(text2)) {
                return (Long)this.getNullValue();
            }
            try {
                return NumberInput.parseLong(text2);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid Long value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Long)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Long parsed = this._parseLong(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Long' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final long _parseLongPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getLongValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            if (text2.length() == 0 || this._hasTextualNull(text2)) {
                return 0L;
            }
            try {
                return NumberInput.parseLong(text2);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid long value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0L;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            long parsed = this._parseLongPrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'long' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Float _parseFloat(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(jp.getFloatValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            if (text2.length() == 0) {
                return (Float)this.getEmptyValue();
            }
            if (this._hasTextualNull(text2)) {
                return (Float)this.getNullValue();
            }
            switch (text2.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text2)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!this._isNaN(text2)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!this._isNegInf(text2)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            try {
                return Float.valueOf(Float.parseFloat(text2));
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid Float value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Float)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Float parsed = this._parseFloat(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Byte' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final float _parseFloatPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getFloatValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            if (text2.length() == 0 || this._hasTextualNull(text2)) {
                return 0.0f;
            }
            switch (text2.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text2)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text2)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text2)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(text2);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid float value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            float parsed = this._parseFloatPrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'float' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Double _parseDouble(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            if (text2.length() == 0) {
                return (Double)this.getEmptyValue();
            }
            if (this._hasTextualNull(text2)) {
                return (Double)this.getNullValue();
            }
            switch (text2.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text2)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text2)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text2)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(text2);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid Double value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Double)this.getNullValue();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Double parsed = this._parseDouble(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Double' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final double _parseDoublePrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = jp.getText().trim();
            if (text2.length() == 0 || this._hasTextualNull(text2)) {
                return 0.0;
            }
            switch (text2.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text2)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text2)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text2)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(text2);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text2, this._valueClass, "not a valid double value");
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            double parsed = this._parseDoublePrimitive(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'Byte' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected Date _parseDate(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Date(jp.getLongValue());
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String value = null;
            try {
                value = jp.getText().trim();
                if (value.length() == 0) {
                    return (Date)this.getEmptyValue();
                }
                if (this._hasTextualNull(value)) {
                    return (Date)this.getNullValue();
                }
                return ctxt.parseDate(value);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(value, this._valueClass, "not a valid representation (error: " + iae.getMessage() + ")");
            }
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            Date parsed = this._parseDate(jp, ctxt);
            t = jp.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'java.util.Date' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected static final double parseDouble(String numStr) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(numStr)) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(numStr);
    }

    protected final String _parseString(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            return jp.getText();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            String parsed = this._parseString(jp, ctxt);
            if (jp.nextToken() != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'String' value but there was more than a single value in the array");
            }
            return parsed;
        }
        String value = jp.getValueAsString();
        if (value != null) {
            return value;
        }
        throw ctxt.mappingException(String.class, jp.getCurrentToken());
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected final boolean _isNegInf(String text2) {
        return "-Infinity".equals(text2) || "-INF".equals(text2);
    }

    protected final boolean _isPosInf(String text2) {
        return "Infinity".equals(text2) || "INF".equals(text2);
    }

    protected final boolean _isNaN(String text2) {
        return "NaN".equals(text2);
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext ctxt, JavaType type2, BeanProperty property) throws JsonMappingException {
        return ctxt.findContextualValueDeserializer(type2, property);
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext ctxt, BeanProperty prop, JsonDeserializer<?> existingDeserializer) throws JsonMappingException {
        Object convDef;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr != null && prop != null && (convDef = intr.findDeserializationContentConverter(prop.getMember())) != null) {
            Converter<Object, Object> conv = ctxt.converterInstance(prop.getMember(), convDef);
            JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
            if (existingDeserializer == null) {
                existingDeserializer = ctxt.findContextualValueDeserializer(delegateType, prop);
            }
            return new StdDelegatingDeserializer<Object>(conv, delegateType, existingDeserializer);
        }
        return existingDeserializer;
    }

    protected void handleUnknownProperty(JsonParser jp, DeserializationContext ctxt, Object instanceOrClass, String propName) throws IOException {
        if (instanceOrClass == null) {
            instanceOrClass = this.handledType();
        }
        if (ctxt.handleUnknownProperty(jp, this, instanceOrClass, propName)) {
            return;
        }
        ctxt.reportUnknownProperty(instanceOrClass, propName, this);
        jp.skipChildren();
    }
}

