/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanDescription;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.KeyDeserializers;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.ClassUtil;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.EnumResolver;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 923268084968181479L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver<?> enumResolver, AnnotatedMethod factory) {
        return new StdKeyDeserializer.EnumKD(enumResolver, factory);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig config, JavaType type2, JsonDeserializer<?> deser) {
        return new StdKeyDeserializer.DelegatingKD(type2.getRawClass(), deser);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig config, JavaType type2) {
        Object beanDesc = config.introspect(type2);
        Constructor<?> ctor = ((BeanDescription)beanDesc).findSingleArgConstructor(String.class);
        if (ctor != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(ctor);
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(ctor);
        }
        Method m = ((BeanDescription)beanDesc).findFactoryMethod(String.class);
        if (m != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m);
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(m);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type2, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type2.getRawClass();
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType(raw);
        }
        return StdKeyDeserializer.forType(raw);
    }
}

