/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl;

import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;

public abstract class PropertySerializerMap {
    public abstract JsonSerializer<Object> serializerFor(Class<?> var1);

    @Deprecated
    public final SerializerAndMapResult findAndAddSerializer(Class<?> type2, SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        return this.findAndAddSecondarySerializer(type2, provider, property);
    }

    @Deprecated
    public final SerializerAndMapResult findAndAddSerializer(JavaType type2, SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        return this.findAndAddSecondarySerializer(type2, provider, property);
    }

    public final SerializerAndMapResult findAndAddPrimarySerializer(Class<?> type2, SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> serializer = provider.findPrimaryPropertySerializer(type2, property);
        return new SerializerAndMapResult(serializer, this.newWith(type2, serializer));
    }

    public final SerializerAndMapResult findAndAddPrimarySerializer(JavaType type2, SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> serializer = provider.findPrimaryPropertySerializer(type2, property);
        return new SerializerAndMapResult(serializer, this.newWith(type2.getRawClass(), serializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(Class<?> type2, SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> serializer = provider.findValueSerializer(type2, property);
        return new SerializerAndMapResult(serializer, this.newWith(type2, serializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(JavaType type2, SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> serializer = provider.findValueSerializer(type2, property);
        return new SerializerAndMapResult(serializer, this.newWith(type2.getRawClass(), serializer));
    }

    public abstract PropertySerializerMap newWith(Class<?> var1, JsonSerializer<Object> var2);

    public static PropertySerializerMap emptyMap() {
        return Empty.instance;
    }

    private static final class Multi
    extends PropertySerializerMap {
        private static final int MAX_ENTRIES = 8;
        private final TypeAndSerializer[] _entries;

        public Multi(TypeAndSerializer[] entries) {
            this._entries = entries;
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> type2) {
            for (TypeAndSerializer entry : this._entries) {
                if (entry.type != type2) continue;
                return entry.serializer;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> type2, JsonSerializer<Object> serializer) {
            int len = this._entries.length;
            if (len == 8) {
                return this;
            }
            TypeAndSerializer[] entries = new TypeAndSerializer[len + 1];
            System.arraycopy(this._entries, 0, entries, 0, len);
            entries[len] = new TypeAndSerializer(type2, serializer);
            return new Multi(entries);
        }
    }

    private static final class Double
    extends PropertySerializerMap {
        private final Class<?> _type1;
        private final Class<?> _type2;
        private final JsonSerializer<Object> _serializer1;
        private final JsonSerializer<Object> _serializer2;

        public Double(Class<?> type1, JsonSerializer<Object> serializer1, Class<?> type2, JsonSerializer<Object> serializer2) {
            this._type1 = type1;
            this._serializer1 = serializer1;
            this._type2 = type2;
            this._serializer2 = serializer2;
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> type2) {
            if (type2 == this._type1) {
                return this._serializer1;
            }
            if (type2 == this._type2) {
                return this._serializer2;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> type2, JsonSerializer<Object> serializer) {
            TypeAndSerializer[] ts = new TypeAndSerializer[]{new TypeAndSerializer(this._type1, this._serializer1), new TypeAndSerializer(this._type2, this._serializer2)};
            return new Multi(ts);
        }
    }

    private static final class Single
    extends PropertySerializerMap {
        private final Class<?> _type;
        private final JsonSerializer<Object> _serializer;

        public Single(Class<?> type2, JsonSerializer<Object> serializer) {
            this._type = type2;
            this._serializer = serializer;
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> type2) {
            if (type2 == this._type) {
                return this._serializer;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> type2, JsonSerializer<Object> serializer) {
            return new Double(this._type, this._serializer, type2, serializer);
        }
    }

    private static final class Empty
    extends PropertySerializerMap {
        protected static final Empty instance = new Empty();

        private Empty() {
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> type2) {
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> type2, JsonSerializer<Object> serializer) {
            return new Single(type2, serializer);
        }
    }

    private static final class TypeAndSerializer {
        public final Class<?> type;
        public final JsonSerializer<Object> serializer;

        public TypeAndSerializer(Class<?> type2, JsonSerializer<Object> serializer) {
            this.type = type2;
            this.serializer = serializer;
        }
    }

    public static final class SerializerAndMapResult {
        public final JsonSerializer<Object> serializer;
        public final PropertySerializerMap map;

        public SerializerAndMapResult(JsonSerializer<Object> serializer, PropertySerializerMap map2) {
            this.serializer = serializer;
            this.map = map2;
        }
    }
}

