/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util;

import java.io.Serializable;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanDescription;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.PropertyName;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.cfg.MapperConfig;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.type.ClassKey;
import org.apache.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.LRUMap;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public PropertyName findRootName(Class<?> rootType, MapperConfig<?> config) {
        AnnotatedClass ac;
        ClassKey key = new ClassKey(rootType);
        PropertyName name2 = this._rootNames.get(key);
        if (name2 != null) {
            return name2;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        name2 = intr.findRootName(ac = beanDesc.getClassInfo());
        if (name2 == null || !name2.hasSimpleName()) {
            name2 = new PropertyName(rootType.getSimpleName());
        }
        this._rootNames.put(key, name2);
        return name2;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

