/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.http.client.methods;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hudi.org.apache.http.Consts;
import org.apache.hudi.org.apache.http.Header;
import org.apache.hudi.org.apache.http.HeaderIterator;
import org.apache.hudi.org.apache.http.HttpEntity;
import org.apache.hudi.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.hudi.org.apache.http.HttpRequest;
import org.apache.hudi.org.apache.http.NameValuePair;
import org.apache.hudi.org.apache.http.ProtocolVersion;
import org.apache.hudi.org.apache.http.annotation.NotThreadSafe;
import org.apache.hudi.org.apache.http.client.config.RequestConfig;
import org.apache.hudi.org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.hudi.org.apache.http.client.methods.Configurable;
import org.apache.hudi.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.hudi.org.apache.http.client.methods.HttpRequestBase;
import org.apache.hudi.org.apache.http.client.methods.HttpUriRequest;
import org.apache.hudi.org.apache.http.client.utils.URIBuilder;
import org.apache.hudi.org.apache.http.client.utils.URLEncodedUtils;
import org.apache.hudi.org.apache.http.entity.ContentType;
import org.apache.hudi.org.apache.http.message.BasicHeader;
import org.apache.hudi.org.apache.http.message.BasicNameValuePair;
import org.apache.hudi.org.apache.http.message.HeaderGroup;
import org.apache.hudi.org.apache.http.protocol.HTTP;
import org.apache.hudi.org.apache.http.util.Args;

@NotThreadSafe
public class RequestBuilder {
    private String method;
    private Charset charset;
    private ProtocolVersion version;
    private URI uri;
    private HeaderGroup headergroup;
    private HttpEntity entity;
    private List<NameValuePair> parameters;
    private RequestConfig config;

    RequestBuilder(String method) {
        this.charset = Consts.UTF_8;
        this.method = method;
    }

    RequestBuilder(String method, URI uri2) {
        this.method = method;
        this.uri = uri2;
    }

    RequestBuilder(String method, String uri2) {
        this.method = method;
        this.uri = uri2 != null ? URI.create(uri2) : null;
    }

    RequestBuilder() {
        this(null);
    }

    public static RequestBuilder create(String method) {
        Args.notBlank(method, "HTTP method");
        return new RequestBuilder(method);
    }

    public static RequestBuilder get() {
        return new RequestBuilder("GET");
    }

    public static RequestBuilder get(URI uri2) {
        return new RequestBuilder("GET", uri2);
    }

    public static RequestBuilder get(String uri2) {
        return new RequestBuilder("GET", uri2);
    }

    public static RequestBuilder head() {
        return new RequestBuilder("HEAD");
    }

    public static RequestBuilder head(URI uri2) {
        return new RequestBuilder("HEAD", uri2);
    }

    public static RequestBuilder head(String uri2) {
        return new RequestBuilder("HEAD", uri2);
    }

    public static RequestBuilder patch() {
        return new RequestBuilder("PATCH");
    }

    public static RequestBuilder patch(URI uri2) {
        return new RequestBuilder("PATCH", uri2);
    }

    public static RequestBuilder patch(String uri2) {
        return new RequestBuilder("PATCH", uri2);
    }

    public static RequestBuilder post() {
        return new RequestBuilder("POST");
    }

    public static RequestBuilder post(URI uri2) {
        return new RequestBuilder("POST", uri2);
    }

    public static RequestBuilder post(String uri2) {
        return new RequestBuilder("POST", uri2);
    }

    public static RequestBuilder put() {
        return new RequestBuilder("PUT");
    }

    public static RequestBuilder put(URI uri2) {
        return new RequestBuilder("PUT", uri2);
    }

    public static RequestBuilder put(String uri2) {
        return new RequestBuilder("PUT", uri2);
    }

    public static RequestBuilder delete() {
        return new RequestBuilder("DELETE");
    }

    public static RequestBuilder delete(URI uri2) {
        return new RequestBuilder("DELETE", uri2);
    }

    public static RequestBuilder delete(String uri2) {
        return new RequestBuilder("DELETE", uri2);
    }

    public static RequestBuilder trace() {
        return new RequestBuilder("TRACE");
    }

    public static RequestBuilder trace(URI uri2) {
        return new RequestBuilder("TRACE", uri2);
    }

    public static RequestBuilder trace(String uri2) {
        return new RequestBuilder("TRACE", uri2);
    }

    public static RequestBuilder options() {
        return new RequestBuilder("OPTIONS");
    }

    public static RequestBuilder options(URI uri2) {
        return new RequestBuilder("OPTIONS", uri2);
    }

    public static RequestBuilder options(String uri2) {
        return new RequestBuilder("OPTIONS", uri2);
    }

    public static RequestBuilder copy(HttpRequest request) {
        Args.notNull(request, "HTTP request");
        return new RequestBuilder().doCopy(request);
    }

    private RequestBuilder doCopy(HttpRequest request) {
        if (request == null) {
            return this;
        }
        this.method = request.getRequestLine().getMethod();
        this.version = request.getRequestLine().getProtocolVersion();
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.clear();
        this.headergroup.setHeaders(request.getAllHeaders());
        this.parameters = null;
        this.entity = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity originalEntity = ((HttpEntityEnclosingRequest)request).getEntity();
            ContentType contentType = ContentType.get(originalEntity);
            if (contentType != null && contentType.getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                try {
                    List<NameValuePair> formParams2 = URLEncodedUtils.parse(originalEntity);
                    if (!formParams2.isEmpty()) {
                        this.parameters = formParams2;
                    }
                }
                catch (IOException ignore) {}
            } else {
                this.entity = originalEntity;
            }
        }
        URI originalUri = request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : URI.create(request.getRequestLine().getUri());
        URIBuilder uriBuilder = new URIBuilder(originalUri);
        if (this.parameters == null) {
            List<NameValuePair> queryParams2 = uriBuilder.getQueryParams();
            if (!queryParams2.isEmpty()) {
                this.parameters = queryParams2;
                uriBuilder.clearParameters();
            } else {
                this.parameters = null;
            }
        }
        try {
            this.uri = uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            this.uri = originalUri;
        }
        this.config = request instanceof Configurable ? ((Configurable)((Object)request)).getConfig() : null;
        return this;
    }

    public RequestBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getMethod() {
        return this.method;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public RequestBuilder setVersion(ProtocolVersion version) {
        this.version = version;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public RequestBuilder setUri(URI uri2) {
        this.uri = uri2;
        return this;
    }

    public RequestBuilder setUri(String uri2) {
        this.uri = uri2 != null ? URI.create(uri2) : null;
        return this;
    }

    public Header getFirstHeader(String name2) {
        return this.headergroup != null ? this.headergroup.getFirstHeader(name2) : null;
    }

    public Header getLastHeader(String name2) {
        return this.headergroup != null ? this.headergroup.getLastHeader(name2) : null;
    }

    public Header[] getHeaders(String name2) {
        return this.headergroup != null ? this.headergroup.getHeaders(name2) : null;
    }

    public RequestBuilder addHeader(Header header) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.addHeader(header);
        return this;
    }

    public RequestBuilder addHeader(String name2, String value) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.addHeader(new BasicHeader(name2, value));
        return this;
    }

    public RequestBuilder removeHeader(Header header) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.removeHeader(header);
        return this;
    }

    public RequestBuilder removeHeaders(String name2) {
        if (name2 == null || this.headergroup == null) {
            return this;
        }
        HeaderIterator i = this.headergroup.iterator();
        while (i.hasNext()) {
            Header header = i.nextHeader();
            if (!name2.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
        return this;
    }

    public RequestBuilder setHeader(Header header) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.updateHeader(header);
        return this;
    }

    public RequestBuilder setHeader(String name2, String value) {
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.updateHeader(new BasicHeader(name2, value));
        return this;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public RequestBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public List<NameValuePair> getParameters() {
        return this.parameters != null ? new ArrayList<NameValuePair>(this.parameters) : new ArrayList();
    }

    public RequestBuilder addParameter(NameValuePair nvp) {
        Args.notNull(nvp, "Name value pair");
        if (this.parameters == null) {
            this.parameters = new LinkedList<NameValuePair>();
        }
        this.parameters.add(nvp);
        return this;
    }

    public RequestBuilder addParameter(String name2, String value) {
        return this.addParameter(new BasicNameValuePair(name2, value));
    }

    public RequestBuilder addParameters(NameValuePair ... nvps) {
        for (NameValuePair nvp : nvps) {
            this.addParameter(nvp);
        }
        return this;
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public RequestBuilder setConfig(RequestConfig config) {
        this.config = config;
        return this;
    }

    public HttpUriRequest build() {
        HttpRequestBase result2;
        URI uriNotNull = this.uri != null ? this.uri : URI.create("/");
        HttpEntity entityCopy = this.entity;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (entityCopy == null && ("POST".equalsIgnoreCase(this.method) || "PUT".equalsIgnoreCase(this.method))) {
                entityCopy = new UrlEncodedFormEntity(this.parameters, HTTP.DEF_CONTENT_CHARSET);
            } else {
                try {
                    uriNotNull = new URIBuilder(uriNotNull).setCharset(this.charset).addParameters(this.parameters).build();
                }
                catch (URISyntaxException ex) {
                    // empty catch block
                }
            }
        }
        if (entityCopy == null) {
            result2 = new InternalRequest(this.method);
        } else {
            InternalEntityEclosingRequest request = new InternalEntityEclosingRequest(this.method);
            request.setEntity(entityCopy);
            result2 = request;
        }
        result2.setProtocolVersion(this.version);
        result2.setURI(uriNotNull);
        if (this.headergroup != null) {
            result2.setHeaders(this.headergroup.getAllHeaders());
        }
        result2.setConfig(this.config);
        return result2;
    }

    static class InternalEntityEclosingRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        InternalEntityEclosingRequest(String method) {
            this.method = method;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }

    static class InternalRequest
    extends HttpRequestBase {
        private final String method;

        InternalRequest(String method) {
            this.method = method;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }
}

