/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.util.ajax;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.org.eclipse.jetty.util.ajax.JSON;

public class JSONObjectConvertor
implements JSON.Convertor {
    private boolean _fromJSON;
    private Set _excluded = null;

    public JSONObjectConvertor() {
        this._fromJSON = false;
    }

    public JSONObjectConvertor(boolean fromJSON) {
        this._fromJSON = fromJSON;
    }

    public JSONObjectConvertor(boolean fromJSON, String[] excluded) {
        this._fromJSON = fromJSON;
        if (excluded != null) {
            this._excluded = new HashSet<String>(Arrays.asList(excluded));
        }
    }

    @Override
    public Object fromJSON(Map map2) {
        if (this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        return map2;
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        try {
            Class<?> c = obj.getClass();
            if (this._fromJSON) {
                out.addClass(obj.getClass());
            }
            Method[] methods2 = obj.getClass().getMethods();
            for (int i = 0; i < methods2.length; ++i) {
                Method m = methods2[i];
                if (Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 0 || m.getReturnType() == null || m.getDeclaringClass() == Object.class) continue;
                String name2 = m.getName();
                if (name2.startsWith("is")) {
                    name2 = name2.substring(2, 3).toLowerCase(Locale.ENGLISH) + name2.substring(3);
                } else {
                    if (!name2.startsWith("get")) continue;
                    name2 = name2.substring(3, 4).toLowerCase(Locale.ENGLISH) + name2.substring(4);
                }
                if (!this.includeField(name2, obj, m)) continue;
                out.add(name2, m.invoke(obj, (Object[])null));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected boolean includeField(String name2, Object o, Method m) {
        return this._excluded == null || !this._excluded.contains(name2);
    }
}

