/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.Permission;
import org.apache.hudi.org.eclipse.jetty.util.IO;
import org.apache.hudi.org.eclipse.jetty.util.StringUtil;
import org.apache.hudi.org.eclipse.jetty.util.URIUtil;
import org.apache.hudi.org.eclipse.jetty.util.log.Log;
import org.apache.hudi.org.eclipse.jetty.util.log.Logger;
import org.apache.hudi.org.eclipse.jetty.util.resource.PathResource;
import org.apache.hudi.org.eclipse.jetty.util.resource.Resource;

@Deprecated
public class FileResource
extends Resource {
    private static final Logger LOG = Log.getLogger(FileResource.class);
    private final File _file;
    private final URI _uri;
    private final URI _alias;

    public FileResource(URL url2) throws IOException, URISyntaxException {
        File file;
        try {
            file = new File(url2.toURI());
            this.assertValidPath(file.toString());
        }
        catch (URISyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            if (!url2.toString().startsWith("file:")) {
                throw new IllegalArgumentException("!file:");
            }
            LOG.ignore(e);
            try {
                String fileUrl = "file:" + URIUtil.encodePath(url2.toString().substring(5));
                URI uri2 = new URI(fileUrl);
                file = uri2.getAuthority() == null ? new File(uri2) : new File("//" + uri2.getAuthority() + URIUtil.decodePath(url2.getFile()));
            }
            catch (Exception ex2) {
                LOG.ignore(ex2);
                URLConnection connection = url2.openConnection();
                Permission perm = connection.getPermission();
                file = new File(perm == null ? url2.getFile() : perm.getName());
            }
        }
        this._file = file;
        this._uri = FileResource.normalizeURI(this._file, url2.toURI());
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    public FileResource(URI uri2) {
        File file;
        this._file = file = new File(uri2);
        try {
            URI fileUri = this._file.toURI();
            this._uri = FileResource.normalizeURI(this._file, uri2);
            this.assertValidPath(file.toString());
            this._alias = !URIUtil.equalsIgnoreEncodings(this._uri.toASCIIString(), fileUri.toString()) ? this._file.toURI() : FileResource.checkFileAlias(this._uri, this._file);
        }
        catch (URISyntaxException e) {
            throw new InvalidPathException(this._file.toString(), e.getMessage()){
                {
                    super(arg0, arg1);
                    this.initCause(e);
                }
            };
        }
    }

    public FileResource(File file) {
        this.assertValidPath(file.toString());
        this._file = file;
        try {
            this._uri = FileResource.normalizeURI(this._file, this._file.toURI());
        }
        catch (URISyntaxException e) {
            throw new InvalidPathException(this._file.toString(), e.getMessage()){
                {
                    super(arg0, arg1);
                    this.initCause(e);
                }
            };
        }
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    public FileResource(File base2, String childPath) {
        URI uri2;
        String encoded = URIUtil.encodePath(childPath);
        this._file = new File(base2, childPath);
        try {
            uri2 = base2.isDirectory() ? new URI(URIUtil.addEncodedPaths(base2.toURI().toASCIIString(), encoded)) : new URI(base2.toURI().toASCIIString() + encoded);
        }
        catch (URISyntaxException e) {
            throw new InvalidPathException(base2.toString() + childPath, e.getMessage()){
                {
                    super(arg0, arg1);
                    this.initCause(e);
                }
            };
        }
        this._uri = uri2;
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    @Override
    public boolean isSame(Resource resource) {
        block4: {
            try {
                if (resource instanceof PathResource) {
                    Path path = ((PathResource)resource).getPath();
                    return Files.isSameFile(this.getFile().toPath(), path);
                }
                if (resource instanceof FileResource) {
                    Path path = ((FileResource)resource).getFile().toPath();
                    return Files.isSameFile(this.getFile().toPath(), path);
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("ignored", e);
            }
        }
        return false;
    }

    private static URI normalizeURI(File file, URI uri2) throws URISyntaxException {
        String u = uri2.toASCIIString();
        if (file.isDirectory()) {
            if (!u.endsWith("/")) {
                u = u + "/";
            }
        } else if (file.exists() && u.endsWith("/")) {
            u = u.substring(0, u.length() - 1);
        }
        return new URI(u);
    }

    private static URI checkFileAlias(URI uri2, File file) {
        try {
            String can;
            if (!URIUtil.equalsIgnoreEncodings(uri2, file.toURI())) {
                return new File(uri2).getAbsoluteFile().toURI();
            }
            String abs = file.getAbsolutePath();
            if (!abs.equals(can = file.getCanonicalPath())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ALIAS abs={} can={}", abs, can);
                }
                URI alias = new File(can).toURI();
                return new URI("file://" + URIUtil.encodePath(alias.getPath()));
            }
        }
        catch (Exception e) {
            LOG.warn("bad alias for {}: {}", file, e.toString());
            LOG.debug(e);
            try {
                return new URI("https://eclipse.org/bad/canonical/alias");
            }
            catch (Exception ex2) {
                LOG.ignore(ex2);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Resource addPath(String path) throws IOException {
        this.assertValidPath(path);
        if (URIUtil.canonicalPath(path) == null) {
            throw new MalformedURLException(path);
        }
        if ("/".equals(path)) {
            return this;
        }
        return new FileResource(this._file, path);
    }

    private void assertValidPath(String path) {
        int idx = StringUtil.indexOfControlChars(path);
        if (idx >= 0) {
            throw new InvalidPathException(path, "Invalid Character at index " + idx);
        }
    }

    @Override
    public URI getAlias() {
        return this._alias;
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public long lastModified() {
        return this._file.lastModified();
    }

    @Override
    public boolean isDirectory() {
        return this._file.exists() && this._file.isDirectory() || this._uri.toASCIIString().endsWith("/");
    }

    @Override
    public long length() {
        return this._file.length();
    }

    @Override
    public String getName() {
        return this._file.getAbsolutePath();
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return FileChannel.open(this._file.toPath(), StandardOpenOption.READ);
    }

    @Override
    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof FileResource) {
            return this._file.renameTo(((FileResource)dest)._file);
        }
        return false;
    }

    @Override
    public String[] list() {
        String[] list = this._file.list();
        if (list == null) {
            return null;
        }
        int i = list.length;
        while (i-- > 0) {
            if (!new File(this._file, list[i]).isDirectory() || list[i].endsWith("/")) continue;
            int n = i;
            list[n] = list[n] + "/";
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof FileResource)) {
            return false;
        }
        FileResource f = (FileResource)o;
        return f._file == this._file || null != this._file && this._file.equals(f._file);
    }

    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    @Override
    public void copyTo(File destination) throws IOException {
        if (this.isDirectory()) {
            IO.copyDir(this.getFile(), destination);
        } else {
            if (destination.exists()) {
                throw new IllegalArgumentException(destination + " exists");
            }
            IO.copy(this.getFile(), destination);
        }
    }

    @Override
    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public URL getURL() {
        try {
            return this._uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public URI getURI() {
        return this._uri;
    }

    public String toString() {
        return this._uri.toString();
    }
}

