/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.websocket.common.extensions;

import java.io.IOException;
import org.apache.hudi.org.eclipse.jetty.util.StringUtil;
import org.apache.hudi.org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.apache.hudi.org.eclipse.jetty.util.component.Dumpable;
import org.apache.hudi.org.eclipse.jetty.util.component.LifeCycle;
import org.apache.hudi.org.eclipse.jetty.util.compression.DeflaterPool;
import org.apache.hudi.org.eclipse.jetty.util.compression.InflaterPool;
import org.apache.hudi.org.eclipse.jetty.websocket.api.WebSocketException;
import org.apache.hudi.org.eclipse.jetty.websocket.api.extensions.Extension;
import org.apache.hudi.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.apache.hudi.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.apache.hudi.org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.apache.hudi.org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;
import org.apache.hudi.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketExtensionFactory
extends ExtensionFactory
implements LifeCycle,
Dumpable {
    private final ContainerLifeCycle containerLifeCycle;
    private final WebSocketContainerScope container;
    private final InflaterPool inflaterPool;
    private final DeflaterPool deflaterPool;

    public WebSocketExtensionFactory(WebSocketContainerScope container2) {
        this(container2, null, null);
    }

    public WebSocketExtensionFactory(WebSocketContainerScope container2, InflaterPool inflaterPool, DeflaterPool deflaterPool) {
        this.container = container2;
        this.containerLifeCycle = new ContainerLifeCycle(){

            @Override
            public String toString() {
                return String.format("%s@%x{%s}", WebSocketExtensionFactory.class.getSimpleName(), this.hashCode(), WebSocketExtensionFactory.this.containerLifeCycle.getState());
            }
        };
        this.inflaterPool = inflaterPool != null ? inflaterPool : new InflaterPool(-1, true);
        this.containerLifeCycle.addBean(this.inflaterPool);
        this.deflaterPool = deflaterPool != null ? deflaterPool : new DeflaterPool(-1, -1, true);
        this.containerLifeCycle.addBean(this.deflaterPool);
    }

    public void unmanage(Object object) {
        this.containerLifeCycle.unmanage(object);
    }

    public InflaterPool getInflaterPool() {
        return this.inflaterPool;
    }

    public DeflaterPool getDeflaterPool() {
        return this.deflaterPool;
    }

    @Override
    public Extension newInstance(ExtensionConfig config) {
        if (config == null) {
            return null;
        }
        String name2 = config.getName();
        if (StringUtil.isBlank(name2)) {
            return null;
        }
        Class<? extends Extension> extClass = this.getExtension(name2);
        if (extClass == null) {
            return null;
        }
        try {
            Extension ext = this.container.getObjectFactory().createInstance(extClass);
            if (ext instanceof AbstractExtension) {
                AbstractExtension aext = (AbstractExtension)ext;
                aext.init(this.container);
                aext.setConfig(config);
            }
            if (ext instanceof CompressExtension) {
                CompressExtension cext = (CompressExtension)ext;
                cext.setInflaterPool(this.inflaterPool);
                cext.setDeflaterPool(this.deflaterPool);
            }
            return ext;
        }
        catch (Exception e) {
            throw new WebSocketException("Cannot instantiate extension: " + extClass, e);
        }
    }

    @Override
    public void start() throws Exception {
        this.containerLifeCycle.start();
    }

    @Override
    public void stop() throws Exception {
        this.containerLifeCycle.stop();
    }

    @Override
    public boolean isRunning() {
        return this.containerLifeCycle.isRunning();
    }

    @Override
    public boolean isStarted() {
        return this.containerLifeCycle.isStarted();
    }

    @Override
    public boolean isStarting() {
        return this.containerLifeCycle.isStarting();
    }

    @Override
    public boolean isStopping() {
        return this.containerLifeCycle.isStopping();
    }

    @Override
    public boolean isStopped() {
        return this.containerLifeCycle.isStopped();
    }

    @Override
    public boolean isFailed() {
        return this.containerLifeCycle.isFailed();
    }

    @Override
    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.containerLifeCycle.addLifeCycleListener(listener);
    }

    @Override
    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this.containerLifeCycle.removeLifeCycleListener(listener);
    }

    @Override
    public String dump() {
        return this.containerLifeCycle.dump();
    }

    @Override
    public String dumpSelf() {
        return this.containerLifeCycle.dumpSelf();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.containerLifeCycle.dump(out, indent);
    }

    public String toString() {
        return this.containerLifeCycle.toString();
    }
}

