/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.info;

import java.lang.reflect.Field;
import org.apache.hudi.org.openjdk.jol.info.AbstractGraphWalker;
import org.apache.hudi.org.openjdk.jol.info.GraphStats;
import org.apache.hudi.org.openjdk.jol.util.ObjectUtils;
import org.apache.hudi.org.openjdk.jol.util.SimpleIdentityHashSet;
import org.apache.hudi.org.openjdk.jol.util.SimpleStack;
import org.apache.hudi.org.openjdk.jol.vm.VM;
import org.apache.hudi.org.openjdk.jol.vm.VirtualMachine;

public class GraphStatsWalker
extends AbstractGraphWalker {
    public GraphStats walk(Object ... roots) {
        this.verifyRoots(roots);
        GraphStats data2 = new GraphStats();
        SimpleIdentityHashSet visited = new SimpleIdentityHashSet();
        SimpleStack<Object> s = new SimpleStack<Object>();
        VirtualMachine vm = VM.current();
        for (Object root : roots) {
            if (!visited.add(root)) continue;
            data2.addRecord(vm.sizeOf(root));
            s.push(root);
        }
        while (!s.isEmpty()) {
            Object o = s.pop();
            Class<?> cl = o.getClass();
            if (cl.isArray()) {
                if (cl.getComponentType().isPrimitive()) continue;
                for (Object e : (Object[])o) {
                    if (e == null || !visited.add(e)) continue;
                    s.push(e);
                }
                continue;
            }
            for (Field f : this.getAllReferenceFields(cl)) {
                Object e = ObjectUtils.value(o, f);
                if (e == null || !visited.add(e)) continue;
                data2.addRecord(vm.sizeOf(e));
                s.push(e);
            }
        }
        return data2;
    }
}

