/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.vm;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.hudi.org.openjdk.jol.vm.HotspotUnsafe;
import org.apache.hudi.org.openjdk.jol.vm.InstrumentationSupport;
import org.apache.hudi.org.openjdk.jol.vm.VirtualMachine;
import org.apache.hudi.org.openjdk.jol.vm.sa.ServiceabilityAgentSupport;
import org.apache.hudi.org.openjdk.jol.vm.sa.UniverseData;
import sun.misc.Unsafe;

public class VM {
    private static VirtualMachine INSTANCE;

    private static Unsafe tryUnsafe() {
        return AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

            @Override
            public Unsafe run() {
                try {
                    Field unsafe = Unsafe.class.getDeclaredField("theUnsafe");
                    unsafe.setAccessible(true);
                    return (Unsafe)unsafe.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public static VirtualMachine current() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        String name2 = System.getProperty("java.vm.name");
        if (!name2.contains("HotSpot") && !name2.contains("OpenJDK")) {
            throw new IllegalStateException("Only HotSpot/OpenJDK VMs are supported");
        }
        Unsafe u = VM.tryUnsafe();
        if (u == null) {
            throw new IllegalStateException("Unsafe is not available.");
        }
        Instrumentation inst = null;
        try {
            inst = InstrumentationSupport.instance();
        }
        catch (Exception e) {
            System.out.println("# WARNING: Unable to get Instrumentation. " + e.getMessage());
        }
        try {
            UniverseData saDetails = ServiceabilityAgentSupport.instance().getUniverseData();
            INSTANCE = new HotspotUnsafe(u, inst, saDetails);
        }
        catch (Exception e) {
            System.out.println("# WARNING: Unable to attach Serviceability Agent. " + e.getMessage());
            INSTANCE = new HotspotUnsafe(u, inst);
        }
        return INSTANCE;
    }
}

