/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.vm.sa;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.org.openjdk.jol.util.ClassUtils;
import org.apache.hudi.org.openjdk.jol.util.IOUtils;
import org.apache.hudi.org.openjdk.jol.vm.sa.AttachMain;
import org.apache.hudi.org.openjdk.jol.vm.sa.Request;
import org.apache.hudi.org.openjdk.jol.vm.sa.Response;
import org.apache.hudi.org.openjdk.jol.vm.sa.Result;
import org.apache.hudi.org.openjdk.jol.vm.sa.SASupportException;
import org.apache.hudi.org.openjdk.jol.vm.sa.SenseAccessMain;
import org.apache.hudi.org.openjdk.jol.vm.sa.Task;
import org.apache.hudi.org.openjdk.jol.vm.sa.UniverseData;
import org.apache.hudi.org.openjdk.jol.vm.sa.UniverseTask;
import sun.management.VMManagement;

public class ServiceabilityAgentSupport {
    private static ServiceabilityAgentSupport INSTANCE;
    private final long processId = ServiceabilityAgentSupport.getCurrentProcId();
    private final boolean sudoRequired;
    private final AgentStyle agentStyle = this.senseAgentStyle();

    public static ServiceabilityAgentSupport instance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        if (Boolean.getBoolean("jol.skipHotspotSAAttach")) {
            throw new IllegalStateException("HotSpot Serviceability Agent attach skipped due to jol.skipHotspotSAAttach flag.");
        }
        INSTANCE = new ServiceabilityAgentSupport();
        return INSTANCE;
    }

    private ServiceabilityAgentSupport() {
        this.sudoRequired = this.needSudo(this.agentStyle);
    }

    private AgentStyle senseAgentStyle() {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (AgentStyle style : AgentStyle.values()) {
            try {
                this.senseAccess(style);
                return style;
            }
            catch (Throwable t1) {
                exceptions.add(t1);
            }
        }
        throw new SASupportException("Unable to attach even with module exceptions: " + exceptions, (Throwable)exceptions.get(exceptions.size() - 1));
    }

    private boolean needSudo(AgentStyle style) {
        try {
            this.callAgent(null, false, style);
            return false;
        }
        catch (Throwable t1) {
            if (ServiceabilityAgentSupport.isSudoValidOS() && Boolean.getBoolean("jol.tryWithSudo")) {
                try {
                    this.callAgent(null, true, style);
                    return true;
                }
                catch (Throwable t2) {
                    throw new SASupportException("Unable to attach even with escalated privileges: " + t2.getMessage(), t2);
                }
            }
            throw new SASupportException("You can try again with escalated privileges. Two options: a) use -Djol.tryWithSudo=true to try with sudo; b) echo 0 | sudo tee /proc/sys/kernel/yama/ptrace_scope");
        }
    }

    private static String normalizePath(String path) {
        return path.replace('\\', '/');
    }

    private static boolean isSudoValidOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("nix") || osName.contains("nux") || osName.contains("aix") || osName.contains("mac");
    }

    private static long getCurrentProcId() {
        try {
            Class<?> c = ClassUtils.loadClass("java.lang.ProcessHandle");
            Object current = c.getDeclaredMethod("current", new Class[0]).invoke(null, new Object[0]);
            return (Long)c.getDeclaredMethod("pid", new Class[0]).invoke(current, new Object[0]);
        }
        catch (Throwable c) {
            try {
                RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
                Field jvmField = mxbean.getClass().getDeclaredField("jvm");
                jvmField.setAccessible(true);
                VMManagement management = (VMManagement)jvmField.get(mxbean);
                Method method = management.getClass().getDeclaredMethod("getProcessId", new Class[0]);
                method.setAccessible(true);
                return ((Integer)method.invoke((Object)management, new Object[0])).intValue();
            }
            catch (Throwable t) {
                throw new SASupportException("Couldn't find PID of current JVM process.", t);
            }
        }
    }

    private Result callAgent(Task processor) {
        return this.callAgent(processor, this.sudoRequired, this.agentStyle);
    }

    private Result callAgent(Task processor, boolean sudoRequired, AgentStyle style) {
        Result result2;
        Process agentProcess;
        BufferedReader err;
        ObjectOutputStream out;
        ObjectInputStream in;
        block12: {
            List<String> args2 = this.getArguments(sudoRequired, style);
            args2.add(AttachMain.class.getName());
            in = null;
            out = null;
            err = null;
            agentProcess = null;
            agentProcess = new ProcessBuilder(args2).start();
            Request request = new Request(this.processId, processor, 5000);
            InputStream is = agentProcess.getInputStream();
            OutputStream os = agentProcess.getOutputStream();
            InputStream es = agentProcess.getErrorStream();
            out = new ObjectOutputStream(os);
            out.writeObject(request);
            out.flush();
            int exitCode = agentProcess.waitFor();
            agentProcess = null;
            err = new BufferedReader(new InputStreamReader(es));
            StringBuilder errBuilder = null;
            String line = err.readLine();
            while (line != null) {
                if (errBuilder == null) {
                    errBuilder = new StringBuilder();
                }
                errBuilder.append(line).append("\n");
                line = err.readLine();
            }
            if (errBuilder != null) {
                throw new RuntimeException(errBuilder.toString());
            }
            in = new ObjectInputStream(is);
            Response response = (Response)in.readObject();
            if (response == null) break block12;
            if (response.getError() != null) {
                Throwable error = response.getError();
                throw new RuntimeException(error.getMessage(), error);
            }
            Result result3 = response.getResult();
            IOUtils.safelyClose(out);
            IOUtils.safelyClose(in);
            IOUtils.safelyClose(err);
            if (agentProcess != null) {
                agentProcess.destroy();
            }
            return result3;
        }
        try {
            result2 = null;
        }
        catch (Throwable t) {
            try {
                throw new SASupportException(t.getMessage(), t);
            }
            catch (Throwable throwable) {
                IOUtils.safelyClose(out);
                IOUtils.safelyClose(in);
                IOUtils.safelyClose(err);
                if (agentProcess != null) {
                    agentProcess.destroy();
                }
                throw throwable;
            }
        }
        IOUtils.safelyClose(out);
        IOUtils.safelyClose(in);
        IOUtils.safelyClose(err);
        if (agentProcess != null) {
            agentProcess.destroy();
        }
        return result2;
    }

    private void senseAccess(AgentStyle style) {
        List<String> args2 = this.getArguments(false, style);
        args2.add(SenseAccessMain.class.getName());
        Process agentProcess = null;
        try {
            agentProcess = new ProcessBuilder(args2).start();
            int exitCode = agentProcess.waitFor();
            agentProcess = null;
            if (exitCode != 0) {
                throw new SASupportException("Sense failed.");
            }
        }
        catch (Throwable t) {
            throw new SASupportException(t.getMessage(), t);
        }
        finally {
            if (agentProcess != null) {
                agentProcess.destroy();
            }
        }
    }

    private List<String> getArguments(boolean sudoRequired, AgentStyle style) {
        ArrayList<String> args2 = new ArrayList<String>();
        if (sudoRequired) {
            args2.add("sudo");
        }
        args2.add(ServiceabilityAgentSupport.normalizePath(System.getProperty("java.home")) + "/bin/java");
        switch (style) {
            case NONE: 
            case JDK_8: {
                break;
            }
            case JDK_9: {
                args2.add("--add-modules");
                args2.add("jdk.hotspot.agent");
                args2.add("--add-exports");
                args2.add("jdk.hotspot.agent/sun.jvm.hotspot=ALL-UNNAMED");
                args2.add("--add-exports");
                args2.add("jdk.hotspot.agent/sun.jvm.hotspot.runtime=ALL-UNNAMED");
                args2.add("--add-exports");
                args2.add("jdk.hotspot.agent/sun.jvm.hotspot.memory=ALL-UNNAMED");
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled style: " + (Object)((Object)style));
            }
        }
        String classPath = ServiceabilityAgentSupport.normalizePath(ManagementFactory.getRuntimeMXBean().getClassPath());
        switch (style) {
            case NONE: {
                break;
            }
            case JDK_8: {
                File hotspotAgentLib = new File(ServiceabilityAgentSupport.normalizePath(System.getProperty("java.home")) + "/../lib/sa-jdi.jar");
                classPath = classPath + File.pathSeparator + ServiceabilityAgentSupport.normalizePath(hotspotAgentLib.getAbsolutePath());
                break;
            }
            case JDK_9: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled style: " + (Object)((Object)style));
            }
        }
        if (!classPath.isEmpty()) {
            args2.add("-cp");
            args2.add(classPath);
        }
        return args2;
    }

    public UniverseData getUniverseData() {
        return (UniverseData)this.callAgent(new UniverseTask());
    }

    static enum AgentStyle {
        NONE,
        JDK_8,
        JDK_9;

    }
}

