/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieCompactionHandler;
import org.apache.hudi.table.HoodieTable;

public class CompactionExecutionHelper<T extends HoodieRecordPayload, I, K, O>
implements Serializable {
    protected void transitionRequestedToInflight(HoodieTable table, String compactionInstantTime) {
        HoodieActiveTimeline timeline = table.getActiveTimeline();
        HoodieInstant instant = table.getMetaClient().getInstantGenerator().getCompactionRequestedInstant(compactionInstantTime);
        timeline.transitionCompactionRequestedToInflight(instant);
    }

    protected String instantTimeToUseForScanning(String compactionInstantTime, String maxInstantTime) {
        return maxInstantTime;
    }

    protected boolean shouldPreserveCommitMetadata() {
        return false;
    }

    protected Iterator<List<WriteStatus>> writeFileAndGetWriteStats(HoodieCompactionHandler compactionHandler, CompactionOperation operation, String instantTime, HoodieMergedLogRecordScanner scanner, Option<HoodieBaseFile> oldDataFileOpt) throws IOException {
        Iterator<List<WriteStatus>> result2 = oldDataFileOpt.isPresent() ? compactionHandler.handleUpdate(instantTime, operation.getPartitionPath(), operation.getFileId(), scanner.getRecords(), oldDataFileOpt.get()) : compactionHandler.handleInsert(instantTime, operation.getPartitionPath(), operation.getFileId(), scanner.getRecords());
        return result2;
    }

    protected boolean enableOptimizedLogBlockScan(HoodieWriteConfig writeConfig) {
        return writeConfig.enableOptimizedLogBlocksScan();
    }
}

