/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.Serializable;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.Option;

public class ListingBasedRollbackRequest
implements Serializable {
    private final String partitionPath;
    private final Option<String> fileId;
    private final Option<String> latestBaseInstant;
    private final Option<HoodieWriteStat> writeStat;
    private final Type type;

    public ListingBasedRollbackRequest(String partitionPath, Type type2) {
        this(partitionPath, Option.empty(), Option.empty(), Option.empty(), type2);
    }

    public ListingBasedRollbackRequest(String partitionPath, Option<String> fileId, Option<String> latestBaseInstant, Option<HoodieWriteStat> writeStat, Type type2) {
        this.partitionPath = partitionPath;
        this.fileId = fileId;
        this.latestBaseInstant = latestBaseInstant;
        this.writeStat = writeStat;
        this.type = type2;
    }

    public static ListingBasedRollbackRequest createRollbackRequestWithDeleteDataFilesOnlyAction(String partitionPath) {
        return new ListingBasedRollbackRequest(partitionPath, Type.DELETE_DATA_FILES_ONLY);
    }

    public static ListingBasedRollbackRequest createRollbackRequestWithDeleteDataAndLogFilesAction(String partitionPath) {
        return new ListingBasedRollbackRequest(partitionPath, Type.DELETE_DATA_AND_LOG_FILES);
    }

    public static ListingBasedRollbackRequest createRollbackRequestWithAppendRollbackBlockAction(String partitionPath, String fileId, String baseInstant, HoodieWriteStat writeStat) {
        return new ListingBasedRollbackRequest(partitionPath, Option.of(fileId), Option.of(baseInstant), Option.of(writeStat), Type.APPEND_ROLLBACK_BLOCK);
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public Option<String> getFileId() {
        return this.fileId;
    }

    public Option<String> getLatestBaseInstant() {
        return this.latestBaseInstant;
    }

    public Option<HoodieWriteStat> getWriteStat() {
        return this.writeStat;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        DELETE_DATA_FILES_ONLY,
        DELETE_DATA_AND_LOG_FILES,
        APPEND_ROLLBACK_BLOCK;

    }
}

