/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.ttl.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.config.HoodieTTLConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorType;

public enum PartitionTTLStrategyType {
    KEEP_BY_TIME("org.apache.hudi.table.action.ttl.strategy.KeepByTimeStrategy"),
    KEEP_BY_CREATION_TIME("org.apache.hudi.table.action.ttl.strategy.KeepByCreationTimeStrategy");

    private final String className;

    private PartitionTTLStrategyType(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public static PartitionTTLStrategyType fromClassName(String className) {
        for (PartitionTTLStrategyType type2 : PartitionTTLStrategyType.values()) {
            if (!type2.getClassName().equals(className)) continue;
            return type2;
        }
        throw new IllegalArgumentException("No PartitionTTLStrategyType found for class name: " + className);
    }

    public static List<String> getPartitionTTLStrategyNames() {
        ArrayList<String> names = new ArrayList<String>(PartitionTTLStrategyType.values().length);
        Arrays.stream(PartitionTTLStrategyType.values()).forEach(x -> names.add(x.name()));
        return names;
    }

    @Nullable
    public static String getPartitionTTLStrategyClassName(HoodieConfig config) {
        if (config.contains(HoodieTTLConfig.PARTITION_TTL_STRATEGY_CLASS_NAME)) {
            return config.getString(HoodieTTLConfig.PARTITION_TTL_STRATEGY_CLASS_NAME);
        }
        if (config.contains(HoodieTTLConfig.PARTITION_TTL_STRATEGY_TYPE)) {
            return KeyGeneratorType.valueOf(config.getString(HoodieTTLConfig.PARTITION_TTL_STRATEGY_TYPE)).getClassName();
        }
        return null;
    }
}

