/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.schema.SchemaRegistryProvider;

public class JsonToAvroSchemaConverter
implements SchemaRegistryProvider.SchemaConverter {
    private static final ObjectMapper MAPPER = JsonUtils.getObjectMapper();
    private static final Map<String, String> JSON_TO_AVRO_TYPE = Stream.of({"string", "string"}, {"null", "null"}, {"boolean", "boolean"}, {"integer", "long"}, {"number", "double"}).collect(Collectors.collectingAndThen(Collectors.toMap(p -> p[0], p -> p[1]), Collections::unmodifiableMap));
    private static final Pattern SYMBOL_REGEX = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");

    public JsonToAvroSchemaConverter(TypedProperties properties2) {
    }

    @Override
    public String convert(ParsedSchema parsedSchema) throws IOException {
        JsonSchema jsonSchema = (JsonSchema)parsedSchema;
        JsonNode jsonNode = MAPPER.readTree(jsonSchema.canonicalString());
        ObjectNode avroRecord = MAPPER.createObjectNode().put("type", "record").put("name", JsonToAvroSchemaConverter.getAvroSchemaRecordName(jsonNode)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonNode));
        Option<String> namespace = JsonToAvroSchemaConverter.getAvroSchemaRecordNamespace(jsonNode);
        if (namespace.isPresent()) {
            avroRecord.put("namespace", namespace.get());
        }
        if (jsonNode.hasNonNull("properties")) {
            avroRecord.set("fields", (JsonNode)JsonToAvroSchemaConverter.convertProperties(jsonNode.get("properties"), JsonToAvroSchemaConverter.getRequired(jsonNode)));
        } else {
            avroRecord.set("fields", (JsonNode)MAPPER.createArrayNode());
        }
        return avroRecord.toString();
    }

    private static ArrayNode convertProperties(JsonNode jsonProperties, Set<String> required) {
        ArrayList avroFields = new ArrayList(jsonProperties.size());
        jsonProperties.fieldNames().forEachRemaining(name2 -> avroFields.add(JsonToAvroSchemaConverter.tryConvertNestedProperty(name2, jsonProperties.get(name2)).or(() -> JsonToAvroSchemaConverter.tryConvertArrayProperty(name2, jsonProperties.get(name2))).or(() -> JsonToAvroSchemaConverter.tryConvertEnumProperty(name2, jsonProperties.get(name2))).orElseGet(() -> JsonToAvroSchemaConverter.convertProperty(name2, jsonProperties.get(name2), required.contains(name2)))));
        return MAPPER.createArrayNode().addAll(avroFields);
    }

    private static Option<JsonNode> tryConvertNestedProperty(String name2, JsonNode jsonProperty) {
        if (!JsonToAvroSchemaConverter.isJsonNestedType(jsonProperty)) {
            return Option.empty();
        }
        JsonNode avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name2)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty)).set("type", MAPPER.createObjectNode().put("type", "record").put("name", JsonToAvroSchemaConverter.getAvroTypeName(jsonProperty, name2)).set("fields", (JsonNode)JsonToAvroSchemaConverter.convertProperties(jsonProperty.get("properties"), JsonToAvroSchemaConverter.getRequired(jsonProperty))));
        return Option.of(avroNode);
    }

    private static Option<JsonNode> tryConvertArrayProperty(String name2, JsonNode jsonProperty) {
        if (!JsonToAvroSchemaConverter.isJsonArrayType(jsonProperty)) {
            return Option.empty();
        }
        JsonNode jsonItems = jsonProperty.get("items");
        String itemName = JsonToAvroSchemaConverter.getAvroTypeName(jsonItems, name2) + "_child";
        JsonNode avroItems = JsonToAvroSchemaConverter.isJsonNestedType(jsonItems) ? MAPPER.createObjectNode().put("type", "record").put("name", itemName).set("fields", (JsonNode)JsonToAvroSchemaConverter.convertProperties(jsonItems.get("properties"), JsonToAvroSchemaConverter.getRequired(jsonItems))) : JsonToAvroSchemaConverter.convertProperty(itemName, jsonItems, true);
        JsonNode avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name2)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty)).set("type", MAPPER.createObjectNode().put("type", "array").set("items", avroItems));
        return Option.of(avroNode);
    }

    private static Option<JsonNode> tryConvertEnumProperty(String name2, JsonNode jsonProperty) {
        if (!JsonToAvroSchemaConverter.isJsonEnumType(jsonProperty)) {
            return Option.empty();
        }
        ArrayList enums = new ArrayList();
        jsonProperty.get("enum").iterator().forEachRemaining(e -> enums.add(e.asText()));
        TextNode avroType = enums.stream().allMatch(e -> SYMBOL_REGEX.matcher((CharSequence)e).matches()) ? MAPPER.createObjectNode().put("type", "enum").put("name", JsonToAvroSchemaConverter.getAvroTypeName(jsonProperty, name2)).set("symbols", jsonProperty.get("enum")) : TextNode.valueOf((String)"string");
        JsonNode avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name2)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty)).set("type", (JsonNode)avroType);
        return Option.of(avroNode);
    }

    private static JsonNode convertProperty(String name2, JsonNode jsonProperty, boolean isRequired) {
        boolean nullable;
        ObjectNode avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name2)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty));
        boolean bl = nullable = !isRequired;
        if (jsonProperty.has("default")) {
            avroNode.set("default", jsonProperty.get("default"));
        } else if (nullable) {
            avroNode.set("default", (JsonNode)NullNode.getInstance());
        }
        HashSet<String> avroTypeSet = new HashSet<String>();
        if (jsonProperty.hasNonNull("oneOf") || jsonProperty.hasNonNull("allOf")) {
            Option<JsonNode> allOfTypes;
            Option<JsonNode> oneOfTypes = Option.ofNullable(jsonProperty.get("oneOf"));
            if (oneOfTypes.isPresent()) {
                oneOfTypes.get().elements().forEachRemaining(e -> avroTypeSet.add(JSON_TO_AVRO_TYPE.get(e.get("type").asText())));
            }
            if ((allOfTypes = Option.ofNullable(jsonProperty.get("allOf"))).isPresent()) {
                allOfTypes.get().elements().forEachRemaining(e -> avroTypeSet.add(JSON_TO_AVRO_TYPE.get(e.get("type").asText())));
            }
        } else if (jsonProperty.has("type")) {
            JsonNode jsonType = jsonProperty.get("type");
            if (jsonType.isArray()) {
                jsonType.elements().forEachRemaining(e -> avroTypeSet.add(JSON_TO_AVRO_TYPE.get(e.asText())));
            } else {
                avroTypeSet.add(JSON_TO_AVRO_TYPE.get(jsonType.asText()));
            }
        }
        ArrayList<String> avroTypes = new ArrayList<String>();
        if (nullable || avroTypeSet.contains("null")) {
            avroTypes.add("null");
        }
        avroTypeSet.remove("null");
        avroTypes.addAll(avroTypeSet);
        avroNode.set("type", (JsonNode)(avroTypes.size() > 1 ? MAPPER.createArrayNode().addAll((Collection)avroTypes.stream().map(TextNode::valueOf).collect(Collectors.toList())) : TextNode.valueOf((String)((String)avroTypes.get(0)))));
        return avroNode;
    }

    private static boolean isJsonNestedType(JsonNode jsonNode) {
        return jsonNode.has("type") && Objects.equals(jsonNode.get("type").asText(), "object");
    }

    private static boolean isJsonArrayType(JsonNode jsonNode) {
        return jsonNode.has("type") && Objects.equals(jsonNode.get("type").asText(), "array");
    }

    private static boolean isJsonEnumType(JsonNode jsonNode) {
        return jsonNode.hasNonNull("enum") && jsonNode.get("enum").isArray();
    }

    private static Option<String> getAvroSchemaRecordNamespace(JsonNode jsonNode) {
        if (jsonNode.hasNonNull("$id")) {
            String host2 = URI.create(jsonNode.get("$id").asText()).getHost();
            String avroNamespace = Stream.of(host2.split("\\.")).map(JsonToAvroSchemaConverter::sanitizeAsAvroName).collect(Collectors.joining("."));
            return Option.of(avroNamespace);
        }
        return Option.empty();
    }

    private static String getAvroSchemaRecordName(JsonNode jsonNode) {
        if (jsonNode.hasNonNull("title")) {
            return JsonToAvroSchemaConverter.sanitizeAsAvroName(jsonNode.get("title").asText());
        }
        if (jsonNode.hasNonNull("$id")) {
            String host2 = URI.create(jsonNode.get("$id").asText()).getHost();
            String domain = StringUtils.removeSuffixBy(host2, 46);
            return JsonToAvroSchemaConverter.sanitizeAsAvroName(StringUtils.getSuffixBy(domain, 46));
        }
        return "no_name";
    }

    private static String sanitizeAsAvroName(String s) {
        return s.replaceAll("[^A-Za-z0-9_]+", "_");
    }

    private static Set<String> getRequired(JsonNode jsonNode) {
        if (!jsonNode.hasNonNull("required")) {
            return Collections.emptySet();
        }
        JsonNode requiredNode = jsonNode.get("required");
        HashSet<String> required = new HashSet<String>(requiredNode.size());
        jsonNode.get("required").elements().forEachRemaining(e -> required.add(e.asText()));
        return required;
    }

    private static String getAvroTypeName(JsonNode jsonNode, String defaultName) {
        return jsonNode.hasNonNull("title") ? jsonNode.get("title").asText() : defaultName;
    }

    private static String getAvroDoc(JsonNode jsonNode) {
        return jsonNode.hasNonNull("description") ? jsonNode.get("description").asText() : "";
    }
}

