/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.util.SparkKeyGenUtils;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapExecutor
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapExecutor.class);
    private final HoodieStreamer.Config cfg;
    private transient SchemaProvider schemaProvider;
    private transient JavaSparkContext jssc;
    private final TypedProperties props;
    private final Configuration configuration;
    private final HoodieWriteConfig bootstrapConfig;
    private transient FileSystem fs;
    private String bootstrapBasePath;

    public BootstrapExecutor(HoodieStreamer.Config cfg, JavaSparkContext jssc, FileSystem fs, Configuration conf, TypedProperties properties2) throws IOException {
        this.cfg = cfg;
        this.jssc = jssc;
        this.fs = fs;
        this.configuration = conf;
        this.props = properties2;
        ValidationUtils.checkArgument(properties2.containsKey(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key()), HoodieTableConfig.BOOTSTRAP_BASE_PATH.key() + " must be specified.");
        this.bootstrapBasePath = properties2.getString(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key());
        this.schemaProvider = UtilHelpers.createSchemaProvider(cfg.schemaProviderClassName, this.props, jssc);
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath(cfg.targetBasePath).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(false).build()).forTable(cfg.targetTableName).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withRecordMergeImplClasses(cfg.recordMergeImplClasses).withAutoCommit(true).withProps(this.props);
        if (null != this.schemaProvider && null != this.schemaProvider.getTargetSchema()) {
            builder = builder.withSchema(this.schemaProvider.getTargetSchema().toString());
        }
        this.bootstrapConfig = builder.build();
        LOG.info("Created bootstrap executor with configs : " + this.bootstrapConfig.getProps());
    }

    public void execute() throws IOException {
        this.initializeTable();
        try (SparkRDDWriteClient bootstrapClient = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(this.jssc), this.bootstrapConfig);){
            HashMap<String, String> checkpointCommitMetadata = new HashMap<String, String>();
            checkpointCommitMetadata.put("deltastreamer.checkpoint.key", this.cfg.checkpoint);
            if (this.cfg.checkpoint != null) {
                checkpointCommitMetadata.put("deltastreamer.checkpoint.reset_key", this.cfg.checkpoint);
            }
            bootstrapClient.bootstrap(Option.of(checkpointCommitMetadata));
            this.syncHive();
        }
    }

    private void syncHive() {
        if (this.cfg.enableHiveSync.booleanValue() || this.cfg.enableMetaSync.booleanValue()) {
            TypedProperties metaProps = new TypedProperties();
            metaProps.putAll((Map<?, ?>)this.props);
            metaProps.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), this.cfg.targetBasePath);
            metaProps.put(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT.key(), this.cfg.baseFileFormat);
            if (this.props.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_BUCKET_SYNC.key(), (Boolean)HiveSyncConfigHolder.HIVE_SYNC_BUCKET_SYNC.defaultValue())) {
                metaProps.put(HiveSyncConfigHolder.HIVE_SYNC_BUCKET_SYNC_SPEC.key(), HiveSyncConfig.getBucketSpec((String)this.props.getString(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD.key()), (int)this.props.getInteger(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key())));
            }
            try (HiveSyncTool hiveSyncTool = new HiveSyncTool((Properties)metaProps, this.configuration);){
                hiveSyncTool.syncHoodieTable();
            }
        }
    }

    private void initializeTable() throws IOException {
        Path basePath = new Path(this.cfg.targetBasePath);
        if (this.fs.exists(basePath)) {
            if (this.cfg.bootstrapOverwrite.booleanValue()) {
                LOG.warn("Target base path already exists, overwrite it");
                this.fs.delete(basePath, true);
            } else {
                throw new HoodieException("target base path already exists at " + this.cfg.targetBasePath + ". Cannot bootstrap data on top of an existing table");
            }
        }
        if (this.cfg.targetBasePath.equals(this.bootstrapBasePath)) {
            throw new IllegalArgumentException("Bootstrap source base path and Hudi table base path must be different");
        }
        HoodieTableMetaClient.TableBuilder builder = HoodieTableMetaClient.newTableBuilder().fromProperties(this.props).setTableType(this.cfg.tableType).setTableName(this.cfg.targetTableName).setRecordKeyFields(this.props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key())).setPreCombineField(this.props.getString(HoodieWriteConfig.PRECOMBINE_FIELD_NAME.key(), HoodieWriteConfig.PRECOMBINE_FIELD_NAME.defaultValue())).setTableVersion(ConfigUtils.getIntWithAltKeys(this.props, HoodieWriteConfig.WRITE_TABLE_VERSION)).setPopulateMetaFields(this.props.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS.key(), HoodieTableConfig.POPULATE_META_FIELDS.defaultValue())).setArchiveLogFolder(this.props.getString(HoodieTableConfig.TIMELINE_HISTORY_PATH.key(), HoodieTableConfig.TIMELINE_HISTORY_PATH.defaultValue())).setPayloadClassName(this.cfg.payloadClassName).setRecordMergeMode(this.cfg.recordMergeMode).setRecordMergeStrategyId(this.cfg.recordMergeStrategyId).setBaseFileFormat(this.cfg.baseFileFormat).setBootstrapIndexClass(this.cfg.bootstrapIndexClass).setBootstrapBasePath(this.bootstrapBasePath).setHiveStylePartitioningEnable(this.props.getBoolean(KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), Boolean.parseBoolean(KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.defaultValue()))).setUrlEncodePartitioning(this.props.getBoolean(KeyGeneratorOptions.URL_ENCODE_PARTITIONING.key(), Boolean.parseBoolean(KeyGeneratorOptions.URL_ENCODE_PARTITIONING.defaultValue()))).setCommitTimezone(HoodieTimelineTimeZone.valueOf(this.props.getString(HoodieTableConfig.TIMELINE_TIMEZONE.key(), String.valueOf((Object)HoodieTableConfig.TIMELINE_TIMEZONE.defaultValue())))).setPartitionMetafileUseBaseFormat(this.props.getBoolean(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.key(), HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.defaultValue()));
        String partitionColumnsForKeyGenerator = SparkKeyGenUtils.getPartitionColumnsForKeyGenerator((TypedProperties)this.props);
        if (!StringUtils.isNullOrEmpty(partitionColumnsForKeyGenerator)) {
            builder.setPartitionFields(partitionColumnsForKeyGenerator).setKeyGeneratorClassProp(this.props.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()));
        } else {
            builder.setKeyGeneratorClassProp(this.props.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getName()));
        }
        builder.initTable(HadoopFSUtils.getStorageConfWithCopy(this.jssc.hadoopConfiguration()), this.cfg.targetBasePath);
    }

    public HoodieWriteConfig getBootstrapConfig() {
        return this.bootstrapConfig;
    }
}

